/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;

import com.google.api.client.json.GenericJson;

/**
 * A single permission for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Permission extends GenericJson {

  /**
   * Any additional roles that this permission describes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<String> additionalRoles;

  /**
   * An etag for this permission.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The kind of this permission. This is always drive#permission
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The role that this permission describes. (For example: reader, writer, owner)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String role;

  /**
   * The type of permission (For example: user, group etc).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * Any additional roles that this permission describes.
   * The value returned may be {@code null}.
   */
  public java.util.List<String> getAdditionalRoles() {
    return additionalRoles;
  }

  /**
   * Any additional roles that this permission describes.
   * The value set may be {@code null}.
   */
  public Permission setAdditionalRoles(java.util.List<String> additionalRoles) {
    this.additionalRoles = additionalRoles;
    return this;
  }

  /**
   * An etag for this permission.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * An etag for this permission.
   * The value set may be {@code null}.
   */
  public Permission setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The kind of this permission. This is always drive#permission
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * The kind of this permission. This is always drive#permission
   * The value set may be {@code null}.
   */
  public Permission setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The role that this permission describes. (For example: reader, writer, owner)
   * The value returned may be {@code null}.
   */
  public String getRole() {
    return role;
  }

  /**
   * The role that this permission describes. (For example: reader, writer, owner)
   * The value set may be {@code null}.
   */
  public Permission setRole(String role) {
    this.role = role;
    return this;
  }

  /**
   * The type of permission (For example: user, group etc).
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * The type of permission (For example: user, group etc).
   * The value set may be {@code null}.
   */
  public Permission setType(String type) {
    this.type = type;
    return this;
  }

}
