/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;
import com.google.api.client.util.DateTime;

/**
 * The metadata for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends GenericJson {

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime createdDate;

  /**
   * A short description of the file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String description;

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String downloadUrl;

  /**
   * ETag of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fileExtension;

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long fileSize;

  /**
   * The id of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * Indexable text attributes for the file (can only be written)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexableText indexableText;

  /**
   * The type of file. This is always drive#file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Labels for the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Labels labels;

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime lastViewedDate;

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String md5Checksum;

  /**
   * The mimetype of the file
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String mimeType;

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedByMeDate;

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateTime modifiedDate;

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParentsCollection> parentsCollection;

  static {
    // hack to force ProGuard to consider ParentsCollection used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(ParentsCollection.class);
  }

  /**
   * A link back to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The title of this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String title;

  /**
   * The permissions for the authenticated user on this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permission userPermission;

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * Create time for this file (formatted ISO8601 timestamp).
   * The value set may be {@code null}.
   */
  public File setCreatedDate(DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * A short description of the file
   * The value returned may be {@code null}.
   */
  public String getDescription() {
    return description;
  }

  /**
   * A short description of the file
   * The value set may be {@code null}.
   */
  public File setDescription(String description) {
    this.description = description;
    return this;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value returned may be {@code null}.
   */
  public String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * Short term download URL for the file. This will only be populated on files with content stored
   * in Drive.
   * The value set may be {@code null}.
   */
  public File setDownloadUrl(String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * ETag of the file.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of the file.
   * The value set may be {@code null}.
   */
  public File setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getFileExtension() {
    return fileExtension;
  }

  /**
   * The file extension used when downloading this file. This field is read only. To set the
   * extension, include it on title when creating the file. This will only be populated on files
   * with content stored in Drive.
   * The value set may be {@code null}.
   */
  public File setFileExtension(String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value returned may be {@code null}.
   */
  public Long getFileSize() {
    return fileSize;
  }

  /**
   * The size of the file in bytes. This will only be populated on files with content stored in
   * Drive.
   * The value set may be {@code null}.
   */
  public File setFileSize(Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * The id of the file.
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * The id of the file.
   * The value set may be {@code null}.
   */
  public File setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * The value returned may be {@code null}.
   */
  public IndexableText getIndexableText() {
    return indexableText;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * The value set may be {@code null}.
   */
  public File setIndexableText(IndexableText indexableText) {
    this.indexableText = indexableText;
    return this;
  }

  /**
   * The type of file. This is always drive#file
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * The type of file. This is always drive#file
   * The value set may be {@code null}.
   */
  public File setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Labels for the file.
   * The value returned may be {@code null}.
   */
  public Labels getLabels() {
    return labels;
  }

  /**
   * Labels for the file.
   * The value set may be {@code null}.
   */
  public File setLabels(Labels labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getLastViewedDate() {
    return lastViewedDate;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setLastViewedDate(DateTime lastViewedDate) {
    this.lastViewedDate = lastViewedDate;
    return this;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value returned may be {@code null}.
   */
  public String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * An MD5 checksum for the content of this file. This will only be populated on files with content
   * stored in Drive.
   * The value set may be {@code null}.
   */
  public File setMd5Checksum(String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * The mimetype of the file
   * The value returned may be {@code null}.
   */
  public String getMimeType() {
    return mimeType;
  }

  /**
   * The mimetype of the file
   * The value set may be {@code null}.
   */
  public File setMimeType(String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedByMeDate() {
    return modifiedByMeDate;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setModifiedByMeDate(DateTime modifiedByMeDate) {
    this.modifiedByMeDate = modifiedByMeDate;
    return this;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value returned may be {@code null}.
   */
  public DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp).
   * The value set may be {@code null}.
   */
  public File setModifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value returned may be {@code null}.
   */
  public java.util.List<ParentsCollection> getParentsCollection() {
    return parentsCollection;
  }

  /**
   * Collection of parent folders which contain this file. On insert, setting this field will put
   * the file in all of the provided folders. If no folders are provided, the file will be placed in
   * the default root folder. On update, this field is ignored.
   * The value set may be {@code null}.
   */
  public File setParentsCollection(java.util.List<ParentsCollection> parentsCollection) {
    this.parentsCollection = parentsCollection;
    return this;
  }

  /**
   * A link back to this file.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this file.
   * The value set may be {@code null}.
   */
  public File setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The title of this file.
   * The value returned may be {@code null}.
   */
  public String getTitle() {
    return title;
  }

  /**
   * The title of this file.
   * The value set may be {@code null}.
   */
  public File setTitle(String title) {
    this.title = title;
    return this;
  }

  /**
   * The permissions for the authenticated user on this file.
   * The value returned may be {@code null}.
   */
  public Permission getUserPermission() {
    return userPermission;
  }

  /**
   * The permissions for the authenticated user on this file.
   * The value set may be {@code null}.
   */
  public File setUserPermission(Permission userPermission) {
    this.userPermission = userPermission;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   */
  public static final class IndexableText extends GenericJson {

    /**
     * The text to be indexed for this file
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String text;

    /**
     * The text to be indexed for this file
     * The value returned may be {@code null}.
     */
    public String getText() {
      return text;
    }

    /**
     * The text to be indexed for this file
     * The value set may be {@code null}.
     */
    public IndexableText setText(String text) {
      this.text = text;
      return this;
    }

  }

  /**
   * Labels for the file.
   */
  public static final class Labels extends GenericJson {

    /**
     * Whether this file is hidden from the user
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean hidden;

    /**
     * Whether this file is starred by the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean starred;

    /**
     * Whether this file has been trashed.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Boolean trashed;

    /**
     * Whether this file is hidden from the user
     * The value returned may be {@code null}.
     */
    public Boolean getHidden() {
      return hidden;
    }

    /**
     * Whether this file is hidden from the user
     * The value set may be {@code null}.
     */
    public Labels setHidden(Boolean hidden) {
      this.hidden = hidden;
      return this;
    }

    /**
     * Whether this file is starred by the user.
     * The value returned may be {@code null}.
     */
    public Boolean getStarred() {
      return starred;
    }

    /**
     * Whether this file is starred by the user.
     * The value set may be {@code null}.
     */
    public Labels setStarred(Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Whether this file has been trashed.
     * The value returned may be {@code null}.
     */
    public Boolean getTrashed() {
      return trashed;
    }

    /**
     * Whether this file has been trashed.
     * The value set may be {@code null}.
     */
    public Labels setTrashed(Boolean trashed) {
      this.trashed = trashed;
      return this;
    }

  }

  /**
   * Model definition for FileParentsCollection.
   */
  public static final class ParentsCollection extends GenericJson {

    /**
     * The id of this parent
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String id;

    /**
     * A link to get the metadata for this parent
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private String parentLink;

    /**
     * The id of this parent
     * The value returned may be {@code null}.
     */
    public String getId() {
      return id;
    }

    /**
     * The id of this parent
     * The value set may be {@code null}.
     */
    public ParentsCollection setId(String id) {
      this.id = id;
      return this;
    }

    /**
     * A link to get the metadata for this parent
     * The value returned may be {@code null}.
     */
    public String getParentLink() {
      return parentLink;
    }

    /**
     * A link to get the metadata for this parent
     * The value set may be {@code null}.
     */
    public ParentsCollection setParentLink(String parentLink) {
      this.parentLink = parentLink;
      return this;
    }

  }

}
