/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Represents a font family and weight of text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WeightedFontFamily extends com.google.api.client.json.GenericJson {

  /**
   * The font family of the text. The font family can be any font from the Font menu in Docs or from
   * [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fontFamily;

  /**
   * The weight of the font. This field can have any value that's a multiple of `100` between `100`
   * and `900`, inclusive. This range corresponds to the numerical values described in the CSS 2.1
   * Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-boldness), with non-
   * numerical values disallowed. The default value is `400` ("normal"). The font weight makes up
   * just one component of the rendered font weight. A combination of the `weight` and the text
   * style's resolved `bold` value determine the rendered weight, after accounting for inheritance:
   * * If the text is bold and the weight is less than `400`, the rendered weight is 400. * If the
   * text is bold and the weight is greater than or equal to `400` but is less than `700`, the
   * rendered weight is `700`. * If the weight is greater than or equal to `700`, the rendered
   * weight is equal to the weight. * If the text is not bold, the rendered weight is equal to the
   * weight.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer weight;

  /**
   * The font family of the text. The font family can be any font from the Font menu in Docs or from
   * [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * @return value or {@code null} for none
   */
  public java.lang.String getFontFamily() {
    return fontFamily;
  }

  /**
   * The font family of the text. The font family can be any font from the Font menu in Docs or from
   * [Google Fonts] (https://fonts.google.com/). If the font name is unrecognized, the text is
   * rendered in `Arial`.
   * @param fontFamily fontFamily or {@code null} for none
   */
  public WeightedFontFamily setFontFamily(java.lang.String fontFamily) {
    this.fontFamily = fontFamily;
    return this;
  }

  /**
   * The weight of the font. This field can have any value that's a multiple of `100` between `100`
   * and `900`, inclusive. This range corresponds to the numerical values described in the CSS 2.1
   * Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-boldness), with non-
   * numerical values disallowed. The default value is `400` ("normal"). The font weight makes up
   * just one component of the rendered font weight. A combination of the `weight` and the text
   * style's resolved `bold` value determine the rendered weight, after accounting for inheritance:
   * * If the text is bold and the weight is less than `400`, the rendered weight is 400. * If the
   * text is bold and the weight is greater than or equal to `400` but is less than `700`, the
   * rendered weight is `700`. * If the weight is greater than or equal to `700`, the rendered
   * weight is equal to the weight. * If the text is not bold, the rendered weight is equal to the
   * weight.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWeight() {
    return weight;
  }

  /**
   * The weight of the font. This field can have any value that's a multiple of `100` between `100`
   * and `900`, inclusive. This range corresponds to the numerical values described in the CSS 2.1
   * Specification, [section 15.6](https://www.w3.org/TR/CSS21/fonts.html#font-boldness), with non-
   * numerical values disallowed. The default value is `400` ("normal"). The font weight makes up
   * just one component of the rendered font weight. A combination of the `weight` and the text
   * style's resolved `bold` value determine the rendered weight, after accounting for inheritance:
   * * If the text is bold and the weight is less than `400`, the rendered weight is 400. * If the
   * text is bold and the weight is greater than or equal to `400` but is less than `700`, the
   * rendered weight is `700`. * If the weight is greater than or equal to `700`, the rendered
   * weight is equal to the weight. * If the text is not bold, the rendered weight is equal to the
   * weight.
   * @param weight weight or {@code null} for none
   */
  public WeightedFontFamily setWeight(java.lang.Integer weight) {
    this.weight = weight;
    return this;
  }

  @Override
  public WeightedFontFamily set(String fieldName, Object value) {
    return (WeightedFontFamily) super.set(fieldName, value);
  }

  @Override
  public WeightedFontFamily clone() {
    return (WeightedFontFamily) super.clone();
  }

}
