/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Updates the style of a range of table cells.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateTableCellStyleRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableCellStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the table cell background color, set
   * `fields` to `"backgroundColor"`. To reset a property to its default value, include its field
   * name in the field mask but leave the field itself unset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String fields;

  /**
   * The style to set on the table cells. When updating borders, if a cell shares a border with an
   * adjacent cell, the corresponding border property of the adjacent cell is updated as well.
   * Borders that are merged and invisible are not updated. Since updating a border shared by
   * adjacent cells in the same request can cause conflicting border updates, border updates are
   * applied in the following order: - `border_right` - `border_left` - `border_bottom` -
   * `border_top`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellStyle tableCellStyle;

  /**
   * The table range representing the subset of the table to which the updates are applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableRange tableRange;

  /**
   * The location where the table starts in the document. When specified, the updates are applied to
   * all the cells in the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location tableStartLocation;

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableCellStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the table cell background color, set
   * `fields` to `"backgroundColor"`. To reset a property to its default value, include its field
   * name in the field mask but leave the field itself unset.
   * @return value or {@code null} for none
   */
  public String getFields() {
    return fields;
  }

  /**
   * The fields that should be updated. At least one field must be specified. The root
   * `tableCellStyle` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for listing every field. For example to update the table cell background color, set
   * `fields` to `"backgroundColor"`. To reset a property to its default value, include its field
   * name in the field mask but leave the field itself unset.
   * @param fields fields or {@code null} for none
   */
  public UpdateTableCellStyleRequest setFields(String fields) {
    this.fields = fields;
    return this;
  }

  /**
   * The style to set on the table cells. When updating borders, if a cell shares a border with an
   * adjacent cell, the corresponding border property of the adjacent cell is updated as well.
   * Borders that are merged and invisible are not updated. Since updating a border shared by
   * adjacent cells in the same request can cause conflicting border updates, border updates are
   * applied in the following order: - `border_right` - `border_left` - `border_bottom` -
   * `border_top`
   * @return value or {@code null} for none
   */
  public TableCellStyle getTableCellStyle() {
    return tableCellStyle;
  }

  /**
   * The style to set on the table cells. When updating borders, if a cell shares a border with an
   * adjacent cell, the corresponding border property of the adjacent cell is updated as well.
   * Borders that are merged and invisible are not updated. Since updating a border shared by
   * adjacent cells in the same request can cause conflicting border updates, border updates are
   * applied in the following order: - `border_right` - `border_left` - `border_bottom` -
   * `border_top`
   * @param tableCellStyle tableCellStyle or {@code null} for none
   */
  public UpdateTableCellStyleRequest setTableCellStyle(TableCellStyle tableCellStyle) {
    this.tableCellStyle = tableCellStyle;
    return this;
  }

  /**
   * The table range representing the subset of the table to which the updates are applied.
   * @return value or {@code null} for none
   */
  public TableRange getTableRange() {
    return tableRange;
  }

  /**
   * The table range representing the subset of the table to which the updates are applied.
   * @param tableRange tableRange or {@code null} for none
   */
  public UpdateTableCellStyleRequest setTableRange(TableRange tableRange) {
    this.tableRange = tableRange;
    return this;
  }

  /**
   * The location where the table starts in the document. When specified, the updates are applied to
   * all the cells in the table.
   * @return value or {@code null} for none
   */
  public Location getTableStartLocation() {
    return tableStartLocation;
  }

  /**
   * The location where the table starts in the document. When specified, the updates are applied to
   * all the cells in the table.
   * @param tableStartLocation tableStartLocation or {@code null} for none
   */
  public UpdateTableCellStyleRequest setTableStartLocation(Location tableStartLocation) {
    this.tableStartLocation = tableStartLocation;
    return this;
  }

  @Override
  public UpdateTableCellStyleRequest set(String fieldName, Object value) {
    return (UpdateTableCellStyleRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateTableCellStyleRequest clone() {
    return (UpdateTableCellStyleRequest) super.clone();
  }

}
