/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Properties of a tab.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TabProperties extends com.google.api.client.json.GenericJson {

  /**
   * The zero-based index of the tab within the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * Output only. The depth of the tab within the document. Root-level tabs start at 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nestingLevel;

  /**
   * Optional. The ID of the parent tab. Empty when the current tab is a root-level tab, which means
   * it doesn't have any parents.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parentTabId;

  /**
   * Output only. The ID of the tab. This field can't be changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The user-visible name of the tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The zero-based index of the tab within the parent.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * The zero-based index of the tab within the parent.
   * @param index index or {@code null} for none
   */
  public TabProperties setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Output only. The depth of the tab within the document. Root-level tabs start at 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNestingLevel() {
    return nestingLevel;
  }

  /**
   * Output only. The depth of the tab within the document. Root-level tabs start at 0.
   * @param nestingLevel nestingLevel or {@code null} for none
   */
  public TabProperties setNestingLevel(java.lang.Integer nestingLevel) {
    this.nestingLevel = nestingLevel;
    return this;
  }

  /**
   * Optional. The ID of the parent tab. Empty when the current tab is a root-level tab, which means
   * it doesn't have any parents.
   * @return value or {@code null} for none
   */
  public java.lang.String getParentTabId() {
    return parentTabId;
  }

  /**
   * Optional. The ID of the parent tab. Empty when the current tab is a root-level tab, which means
   * it doesn't have any parents.
   * @param parentTabId parentTabId or {@code null} for none
   */
  public TabProperties setParentTabId(java.lang.String parentTabId) {
    this.parentTabId = parentTabId;
    return this;
  }

  /**
   * Output only. The ID of the tab. This field can't be changed.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * Output only. The ID of the tab. This field can't be changed.
   * @param tabId tabId or {@code null} for none
   */
  public TabProperties setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  /**
   * The user-visible name of the tab.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The user-visible name of the tab.
   * @param title title or {@code null} for none
   */
  public TabProperties setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public TabProperties set(String fieldName, Object value) {
    return (TabProperties) super.set(fieldName, value);
  }

  @Override
  public TabProperties clone() {
    return (TabProperties) super.clone();
  }

}
