/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A tab in a document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Tab extends com.google.api.client.json.GenericJson {

  /**
   * The child tabs nested within this tab.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Tab> childTabs;

  /**
   * A tab with document contents, like text and images.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DocumentTab documentTab;

  /**
   * The properties of the tab, like ID and title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TabProperties tabProperties;

  /**
   * The child tabs nested within this tab.
   * @return value or {@code null} for none
   */
  public java.util.List<Tab> getChildTabs() {
    return childTabs;
  }

  /**
   * The child tabs nested within this tab.
   * @param childTabs childTabs or {@code null} for none
   */
  public Tab setChildTabs(java.util.List<Tab> childTabs) {
    this.childTabs = childTabs;
    return this;
  }

  /**
   * A tab with document contents, like text and images.
   * @return value or {@code null} for none
   */
  public DocumentTab getDocumentTab() {
    return documentTab;
  }

  /**
   * A tab with document contents, like text and images.
   * @param documentTab documentTab or {@code null} for none
   */
  public Tab setDocumentTab(DocumentTab documentTab) {
    this.documentTab = documentTab;
    return this;
  }

  /**
   * The properties of the tab, like ID and title.
   * @return value or {@code null} for none
   */
  public TabProperties getTabProperties() {
    return tabProperties;
  }

  /**
   * The properties of the tab, like ID and title.
   * @param tabProperties tabProperties or {@code null} for none
   */
  public Tab setTabProperties(TabProperties tabProperties) {
    this.tabProperties = tabProperties;
    return this;
  }

  @Override
  public Tab set(String fieldName, Object value) {
    return (Tab) super.set(fieldName, value);
  }

  @Override
  public Tab clone() {
    return (Tab) super.clone();
  }

}
