/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A StructuralElement representing a section break. A section is a range of content that has the
 * same SectionStyle. A section break represents the start of a new section, and the section style
 * applies to the section after the section break. The document body always begins with a section
 * break.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SectionBreak extends com.google.api.client.json.GenericJson {

  /**
   * The style of the section after this section break.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SectionStyle sectionStyle;

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedDeletionIds;

  /**
   * The suggested insertion IDs. A SectionBreak may have multiple insertion IDs if it's a nested
   * suggested change. If empty, then this is not a suggested insertion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> suggestedInsertionIds;

  /**
   * The style of the section after this section break.
   * @return value or {@code null} for none
   */
  public SectionStyle getSectionStyle() {
    return sectionStyle;
  }

  /**
   * The style of the section after this section break.
   * @param sectionStyle sectionStyle or {@code null} for none
   */
  public SectionBreak setSectionStyle(SectionStyle sectionStyle) {
    this.sectionStyle = sectionStyle;
    return this;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedDeletionIds() {
    return suggestedDeletionIds;
  }

  /**
   * The suggested deletion IDs. If empty, then there are no suggested deletions of this content.
   * @param suggestedDeletionIds suggestedDeletionIds or {@code null} for none
   */
  public SectionBreak setSuggestedDeletionIds(java.util.List<java.lang.String> suggestedDeletionIds) {
    this.suggestedDeletionIds = suggestedDeletionIds;
    return this;
  }

  /**
   * The suggested insertion IDs. A SectionBreak may have multiple insertion IDs if it's a nested
   * suggested change. If empty, then this is not a suggested insertion.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSuggestedInsertionIds() {
    return suggestedInsertionIds;
  }

  /**
   * The suggested insertion IDs. A SectionBreak may have multiple insertion IDs if it's a nested
   * suggested change. If empty, then this is not a suggested insertion.
   * @param suggestedInsertionIds suggestedInsertionIds or {@code null} for none
   */
  public SectionBreak setSuggestedInsertionIds(java.util.List<java.lang.String> suggestedInsertionIds) {
    this.suggestedInsertionIds = suggestedInsertionIds;
    return this;
  }

  @Override
  public SectionBreak set(String fieldName, Object value) {
    return (SectionBreak) super.set(fieldName, value);
  }

  @Override
  public SectionBreak clone() {
    return (SectionBreak) super.clone();
  }

}
