/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Replaces an existing image with a new image. Replacing an image removes some image effects from
 * the existing image in order to mirror the behavior of the Docs editor.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplaceImageRequest extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the existing image that will be replaced. The ID can be retrieved from the response
   * of a get request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageObjectId;

  /**
   * The replacement method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageReplaceMethod;

  /**
   * The tab that the image to be replaced is in. When omitted, the request is applied to the first
   * tab. In a document containing a single tab: - If provided, must match the singular tab's ID. -
   * If omitted, the request applies to the singular tab. In a document containing multiple tabs: -
   * If provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The URI of the new image. The image is fetched once at insertion time and a copy is stored for
   * display inside the document. Images must be less than 50MB, cannot exceed 25 megapixels, and
   * must be in PNG, JPEG, or GIF format. The provided URI can't surpass 2 KB in length. The URI is
   * saved with the image, and exposed through the ImageProperties.source_uri field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * The ID of the existing image that will be replaced. The ID can be retrieved from the response
   * of a get request.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageObjectId() {
    return imageObjectId;
  }

  /**
   * The ID of the existing image that will be replaced. The ID can be retrieved from the response
   * of a get request.
   * @param imageObjectId imageObjectId or {@code null} for none
   */
  public ReplaceImageRequest setImageObjectId(java.lang.String imageObjectId) {
    this.imageObjectId = imageObjectId;
    return this;
  }

  /**
   * The replacement method.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageReplaceMethod() {
    return imageReplaceMethod;
  }

  /**
   * The replacement method.
   * @param imageReplaceMethod imageReplaceMethod or {@code null} for none
   */
  public ReplaceImageRequest setImageReplaceMethod(java.lang.String imageReplaceMethod) {
    this.imageReplaceMethod = imageReplaceMethod;
    return this;
  }

  /**
   * The tab that the image to be replaced is in. When omitted, the request is applied to the first
   * tab. In a document containing a single tab: - If provided, must match the singular tab's ID. -
   * If omitted, the request applies to the singular tab. In a document containing multiple tabs: -
   * If provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The tab that the image to be replaced is in. When omitted, the request is applied to the first
   * tab. In a document containing a single tab: - If provided, must match the singular tab's ID. -
   * If omitted, the request applies to the singular tab. In a document containing multiple tabs: -
   * If provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * @param tabId tabId or {@code null} for none
   */
  public ReplaceImageRequest setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  /**
   * The URI of the new image. The image is fetched once at insertion time and a copy is stored for
   * display inside the document. Images must be less than 50MB, cannot exceed 25 megapixels, and
   * must be in PNG, JPEG, or GIF format. The provided URI can't surpass 2 KB in length. The URI is
   * saved with the image, and exposed through the ImageProperties.source_uri field.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * The URI of the new image. The image is fetched once at insertion time and a copy is stored for
   * display inside the document. Images must be less than 50MB, cannot exceed 25 megapixels, and
   * must be in PNG, JPEG, or GIF format. The provided URI can't surpass 2 KB in length. The URI is
   * saved with the image, and exposed through the ImageProperties.source_uri field.
   * @param uri uri or {@code null} for none
   */
  public ReplaceImageRequest setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public ReplaceImageRequest set(String fieldName, Object value) {
    return (ReplaceImageRequest) super.set(fieldName, value);
  }

  @Override
  public ReplaceImageRequest clone() {
    return (ReplaceImageRequest) super.clone();
  }

}
