/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Replaces all instances of text matching a criteria with replace text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplaceAllTextRequest extends com.google.api.client.json.GenericJson {

  /**
   * Finds text in the document matching this substring.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SubstringMatchCriteria containsText;

  /**
   * The text that will replace the matched text.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replaceText;

  /**
   * Optional. The criteria used to specify in which tabs the replacement occurs. When omitted, the
   * replacement applies to all tabs. In a document containing a single tab: - If provided, must
   * match the singular tab's ID. - If omitted, the replacement applies to the singular tab. In a
   * document containing multiple tabs: - If provided, the replacement applies to the specified
   * tabs. - If omitted, the replacement applies to all tabs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TabsCriteria tabsCriteria;

  /**
   * Finds text in the document matching this substring.
   * @return value or {@code null} for none
   */
  public SubstringMatchCriteria getContainsText() {
    return containsText;
  }

  /**
   * Finds text in the document matching this substring.
   * @param containsText containsText or {@code null} for none
   */
  public ReplaceAllTextRequest setContainsText(SubstringMatchCriteria containsText) {
    this.containsText = containsText;
    return this;
  }

  /**
   * The text that will replace the matched text.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplaceText() {
    return replaceText;
  }

  /**
   * The text that will replace the matched text.
   * @param replaceText replaceText or {@code null} for none
   */
  public ReplaceAllTextRequest setReplaceText(java.lang.String replaceText) {
    this.replaceText = replaceText;
    return this;
  }

  /**
   * Optional. The criteria used to specify in which tabs the replacement occurs. When omitted, the
   * replacement applies to all tabs. In a document containing a single tab: - If provided, must
   * match the singular tab's ID. - If omitted, the replacement applies to the singular tab. In a
   * document containing multiple tabs: - If provided, the replacement applies to the specified
   * tabs. - If omitted, the replacement applies to all tabs.
   * @return value or {@code null} for none
   */
  public TabsCriteria getTabsCriteria() {
    return tabsCriteria;
  }

  /**
   * Optional. The criteria used to specify in which tabs the replacement occurs. When omitted, the
   * replacement applies to all tabs. In a document containing a single tab: - If provided, must
   * match the singular tab's ID. - If omitted, the replacement applies to the singular tab. In a
   * document containing multiple tabs: - If provided, the replacement applies to the specified
   * tabs. - If omitted, the replacement applies to all tabs.
   * @param tabsCriteria tabsCriteria or {@code null} for none
   */
  public ReplaceAllTextRequest setTabsCriteria(TabsCriteria tabsCriteria) {
    this.tabsCriteria = tabsCriteria;
    return this;
  }

  @Override
  public ReplaceAllTextRequest set(String fieldName, Object value) {
    return (ReplaceAllTextRequest) super.set(fieldName, value);
  }

  @Override
  public ReplaceAllTextRequest clone() {
    return (ReplaceAllTextRequest) super.clone();
  }

}
