/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Properties of a PositionedObject.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PositionedObjectProperties extends com.google.api.client.json.GenericJson {

  /**
   * The embedded object of this positioned object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmbeddedObject embeddedObject;

  /**
   * The positioning of this positioned object relative to the newline of the Paragraph that
   * references this positioned object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PositionedObjectPositioning positioning;

  /**
   * The embedded object of this positioned object.
   * @return value or {@code null} for none
   */
  public EmbeddedObject getEmbeddedObject() {
    return embeddedObject;
  }

  /**
   * The embedded object of this positioned object.
   * @param embeddedObject embeddedObject or {@code null} for none
   */
  public PositionedObjectProperties setEmbeddedObject(EmbeddedObject embeddedObject) {
    this.embeddedObject = embeddedObject;
    return this;
  }

  /**
   * The positioning of this positioned object relative to the newline of the Paragraph that
   * references this positioned object.
   * @return value or {@code null} for none
   */
  public PositionedObjectPositioning getPositioning() {
    return positioning;
  }

  /**
   * The positioning of this positioned object relative to the newline of the Paragraph that
   * references this positioned object.
   * @param positioning positioning or {@code null} for none
   */
  public PositionedObjectProperties setPositioning(PositionedObjectPositioning positioning) {
    this.positioning = positioning;
    return this;
  }

  @Override
  public PositionedObjectProperties set(String fieldName, Object value) {
    return (PositionedObjectProperties) super.set(fieldName, value);
  }

  @Override
  public PositionedObjectProperties clone() {
    return (PositionedObjectProperties) super.clone();
  }

}
