/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Properties specific to a linked Person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PersonProperties extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The email address linked to this Person. This field is always present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Output only. The name of the person if it's displayed in the link text instead of the person's
   * email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The email address linked to this Person. This field is always present.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * Output only. The email address linked to this Person. This field is always present.
   * @param email email or {@code null} for none
   */
  public PersonProperties setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Output only. The name of the person if it's displayed in the link text instead of the person's
   * email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The name of the person if it's displayed in the link text instead of the person's
   * email address.
   * @param name name or {@code null} for none
   */
  public PersonProperties setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public PersonProperties set(String fieldName, Object value) {
    return (PersonProperties) super.set(fieldName, value);
  }

  @Override
  public PersonProperties clone() {
    return (PersonProperties) super.clone();
  }

}
