/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A border around a paragraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParagraphBorder extends com.google.api.client.json.GenericJson {

  /**
   * The color of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OptionalColor color;

  /**
   * The dash style of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dashStyle;

  /**
   * The padding of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension padding;

  /**
   * The width of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimension width;

  /**
   * The color of the border.
   * @return value or {@code null} for none
   */
  public OptionalColor getColor() {
    return color;
  }

  /**
   * The color of the border.
   * @param color color or {@code null} for none
   */
  public ParagraphBorder setColor(OptionalColor color) {
    this.color = color;
    return this;
  }

  /**
   * The dash style of the border.
   * @return value or {@code null} for none
   */
  public java.lang.String getDashStyle() {
    return dashStyle;
  }

  /**
   * The dash style of the border.
   * @param dashStyle dashStyle or {@code null} for none
   */
  public ParagraphBorder setDashStyle(java.lang.String dashStyle) {
    this.dashStyle = dashStyle;
    return this;
  }

  /**
   * The padding of the border.
   * @return value or {@code null} for none
   */
  public Dimension getPadding() {
    return padding;
  }

  /**
   * The padding of the border.
   * @param padding padding or {@code null} for none
   */
  public ParagraphBorder setPadding(Dimension padding) {
    this.padding = padding;
    return this;
  }

  /**
   * The width of the border.
   * @return value or {@code null} for none
   */
  public Dimension getWidth() {
    return width;
  }

  /**
   * The width of the border.
   * @param width width or {@code null} for none
   */
  public ParagraphBorder setWidth(Dimension width) {
    this.width = width;
    return this;
  }

  @Override
  public ParagraphBorder set(String fieldName, Object value) {
    return (ParagraphBorder) super.set(fieldName, value);
  }

  @Override
  public ParagraphBorder clone() {
    return (ParagraphBorder) super.clone();
  }

}
