/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A collection of all the NamedRanges in the document that share a given name.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NamedRanges extends com.google.api.client.json.GenericJson {

  /**
   * The name that all the named ranges share.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The NamedRanges that share the same name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NamedRange> namedRanges;

  static {
    // hack to force ProGuard to consider NamedRange used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(NamedRange.class);
  }

  /**
   * The name that all the named ranges share.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name that all the named ranges share.
   * @param name name or {@code null} for none
   */
  public NamedRanges setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The NamedRanges that share the same name.
   * @return value or {@code null} for none
   */
  public java.util.List<NamedRange> getNamedRanges() {
    return namedRanges;
  }

  /**
   * The NamedRanges that share the same name.
   * @param namedRanges namedRanges or {@code null} for none
   */
  public NamedRanges setNamedRanges(java.util.List<NamedRange> namedRanges) {
    this.namedRanges = namedRanges;
    return this;
  }

  @Override
  public NamedRanges set(String fieldName, Object value) {
    return (NamedRanges) super.set(fieldName, value);
  }

  @Override
  public NamedRanges clone() {
    return (NamedRanges) super.clone();
  }

}
