/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * The properties of a list that describe the look and feel of bullets belonging to paragraphs
 * associated with a list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListProperties extends com.google.api.client.json.GenericJson {

  /**
   * Describes the properties of the bullets at the associated level. A list has at most 9 levels of
   * nesting with nesting level 0 corresponding to the top-most level and nesting level 8
   * corresponding to the most nested level. The nesting levels are returned in ascending order with
   * the least nested returned first.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NestingLevel> nestingLevels;

  /**
   * Describes the properties of the bullets at the associated level. A list has at most 9 levels of
   * nesting with nesting level 0 corresponding to the top-most level and nesting level 8
   * corresponding to the most nested level. The nesting levels are returned in ascending order with
   * the least nested returned first.
   * @return value or {@code null} for none
   */
  public java.util.List<NestingLevel> getNestingLevels() {
    return nestingLevels;
  }

  /**
   * Describes the properties of the bullets at the associated level. A list has at most 9 levels of
   * nesting with nesting level 0 corresponding to the top-most level and nesting level 8
   * corresponding to the most nested level. The nesting levels are returned in ascending order with
   * the least nested returned first.
   * @param nestingLevels nestingLevels or {@code null} for none
   */
  public ListProperties setNestingLevels(java.util.List<NestingLevel> nestingLevels) {
    this.nestingLevels = nestingLevels;
    return this;
  }

  @Override
  public ListProperties set(String fieldName, Object value) {
    return (ListProperties) super.set(fieldName, value);
  }

  @Override
  public ListProperties clone() {
    return (ListProperties) super.clone();
  }

}
