/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Inserts an empty row into a table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InsertTableRowRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether to insert new row below the reference cell location. - `True`: insert below the cell. -
   * `False`: insert above the cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean insertBelow;

  /**
   * The reference table cell location from which rows will be inserted. A new row will be inserted
   * above (or below) the row where the reference cell is. If the reference cell is a merged cell, a
   * new row will be inserted above (or below) the merged cell.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableCellLocation tableCellLocation;

  /**
   * Whether to insert new row below the reference cell location. - `True`: insert below the cell. -
   * `False`: insert above the cell.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getInsertBelow() {
    return insertBelow;
  }

  /**
   * Whether to insert new row below the reference cell location. - `True`: insert below the cell. -
   * `False`: insert above the cell.
   * @param insertBelow insertBelow or {@code null} for none
   */
  public InsertTableRowRequest setInsertBelow(java.lang.Boolean insertBelow) {
    this.insertBelow = insertBelow;
    return this;
  }

  /**
   * The reference table cell location from which rows will be inserted. A new row will be inserted
   * above (or below) the row where the reference cell is. If the reference cell is a merged cell, a
   * new row will be inserted above (or below) the merged cell.
   * @return value or {@code null} for none
   */
  public TableCellLocation getTableCellLocation() {
    return tableCellLocation;
  }

  /**
   * The reference table cell location from which rows will be inserted. A new row will be inserted
   * above (or below) the row where the reference cell is. If the reference cell is a merged cell, a
   * new row will be inserted above (or below) the merged cell.
   * @param tableCellLocation tableCellLocation or {@code null} for none
   */
  public InsertTableRowRequest setTableCellLocation(TableCellLocation tableCellLocation) {
    this.tableCellLocation = tableCellLocation;
    return this;
  }

  @Override
  public InsertTableRowRequest set(String fieldName, Object value) {
    return (InsertTableRowRequest) super.set(fieldName, value);
  }

  @Override
  public InsertTableRowRequest clone() {
    return (InsertTableRowRequest) super.clone();
  }

}
