/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Inserts a table at the specified location. A newline character will be inserted before the
 * inserted table.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InsertTableRequest extends com.google.api.client.json.GenericJson {

  /**
   * The number of columns in the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer columns;

  /**
   * Inserts the table at the end of the given header, footer or document body. A newline character
   * will be inserted before the inserted table. Tables cannot be inserted inside a footnote.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EndOfSegmentLocation endOfSegmentLocation;

  /**
   * Inserts the table at a specific model index. A newline character will be inserted before the
   * inserted table, therefore the table start index will be at the specified location index + 1.
   * The table must be inserted inside the bounds of an existing Paragraph. For instance, it cannot
   * be inserted at a table's start index (i.e. between an existing table and its preceding
   * paragraph). Tables cannot be inserted inside a footnote or equation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * The number of rows in the table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer rows;

  /**
   * The number of columns in the table.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getColumns() {
    return columns;
  }

  /**
   * The number of columns in the table.
   * @param columns columns or {@code null} for none
   */
  public InsertTableRequest setColumns(java.lang.Integer columns) {
    this.columns = columns;
    return this;
  }

  /**
   * Inserts the table at the end of the given header, footer or document body. A newline character
   * will be inserted before the inserted table. Tables cannot be inserted inside a footnote.
   * @return value or {@code null} for none
   */
  public EndOfSegmentLocation getEndOfSegmentLocation() {
    return endOfSegmentLocation;
  }

  /**
   * Inserts the table at the end of the given header, footer or document body. A newline character
   * will be inserted before the inserted table. Tables cannot be inserted inside a footnote.
   * @param endOfSegmentLocation endOfSegmentLocation or {@code null} for none
   */
  public InsertTableRequest setEndOfSegmentLocation(EndOfSegmentLocation endOfSegmentLocation) {
    this.endOfSegmentLocation = endOfSegmentLocation;
    return this;
  }

  /**
   * Inserts the table at a specific model index. A newline character will be inserted before the
   * inserted table, therefore the table start index will be at the specified location index + 1.
   * The table must be inserted inside the bounds of an existing Paragraph. For instance, it cannot
   * be inserted at a table's start index (i.e. between an existing table and its preceding
   * paragraph). Tables cannot be inserted inside a footnote or equation.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * Inserts the table at a specific model index. A newline character will be inserted before the
   * inserted table, therefore the table start index will be at the specified location index + 1.
   * The table must be inserted inside the bounds of an existing Paragraph. For instance, it cannot
   * be inserted at a table's start index (i.e. between an existing table and its preceding
   * paragraph). Tables cannot be inserted inside a footnote or equation.
   * @param location location or {@code null} for none
   */
  public InsertTableRequest setLocation(Location location) {
    this.location = location;
    return this;
  }

  /**
   * The number of rows in the table.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRows() {
    return rows;
  }

  /**
   * The number of rows in the table.
   * @param rows rows or {@code null} for none
   */
  public InsertTableRequest setRows(java.lang.Integer rows) {
    this.rows = rows;
    return this;
  }

  @Override
  public InsertTableRequest set(String fieldName, Object value) {
    return (InsertTableRequest) super.set(fieldName, value);
  }

  @Override
  public InsertTableRequest clone() {
    return (InsertTableRequest) super.clone();
  }

}
