/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Deletes a PositionedObject from the document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeletePositionedObjectRequest extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the positioned object to delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectId;

  /**
   * The tab that the positioned object to delete is in. When omitted, the request is applied to the
   * first tab. In a document containing a single tab: - If provided, must match the singular tab's
   * ID. - If omitted, the request applies to the singular tab. In a document containing multiple
   * tabs: - If provided, the request applies to the specified tab. - If omitted, the request
   * applies to the first tab in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The ID of the positioned object to delete.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectId() {
    return objectId;
  }

  /**
   * The ID of the positioned object to delete.
   * @param objectId objectId or {@code null} for none
   */
  public DeletePositionedObjectRequest setObjectId(java.lang.String objectId) {
    this.objectId = objectId;
    return this;
  }

  /**
   * The tab that the positioned object to delete is in. When omitted, the request is applied to the
   * first tab. In a document containing a single tab: - If provided, must match the singular tab's
   * ID. - If omitted, the request applies to the singular tab. In a document containing multiple
   * tabs: - If provided, the request applies to the specified tab. - If omitted, the request
   * applies to the first tab in the document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The tab that the positioned object to delete is in. When omitted, the request is applied to the
   * first tab. In a document containing a single tab: - If provided, must match the singular tab's
   * ID. - If omitted, the request applies to the singular tab. In a document containing multiple
   * tabs: - If provided, the request applies to the specified tab. - If omitted, the request
   * applies to the first tab in the document.
   * @param tabId tabId or {@code null} for none
   */
  public DeletePositionedObjectRequest setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  @Override
  public DeletePositionedObjectRequest set(String fieldName, Object value) {
    return (DeletePositionedObjectRequest) super.set(fieldName, value);
  }

  @Override
  public DeletePositionedObjectRequest clone() {
    return (DeletePositionedObjectRequest) super.clone();
  }

}
