/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Deletes bullets from all of the paragraphs that overlap with the given range. The nesting level
 * of each paragraph will be visually preserved by adding indent to the start of the corresponding
 * paragraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteParagraphBulletsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The range to delete bullets from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Range range;

  /**
   * The range to delete bullets from.
   * @return value or {@code null} for none
   */
  public Range getRange() {
    return range;
  }

  /**
   * The range to delete bullets from.
   * @param range range or {@code null} for none
   */
  public DeleteParagraphBulletsRequest setRange(Range range) {
    this.range = range;
    return this;
  }

  @Override
  public DeleteParagraphBulletsRequest set(String fieldName, Object value) {
    return (DeleteParagraphBulletsRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteParagraphBulletsRequest clone() {
    return (DeleteParagraphBulletsRequest) super.clone();
  }

}
