/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Deletes a NamedRange.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteNamedRangeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The name of the range(s) to delete. All named ranges with the given name will be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the named range to delete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String namedRangeId;

  /**
   * Optional. The criteria used to specify which tab(s) the range deletion should occur in. When
   * omitted, the range deletion is applied to all tabs. In a document containing a single tab: - If
   * provided, must match the singular tab's ID. - If omitted, the range deletion applies to the
   * singular tab. In a document containing multiple tabs: - If provided, the range deletion applies
   * to the specified tabs. - If not provided, the range deletion applies to all tabs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TabsCriteria tabsCriteria;

  /**
   * The name of the range(s) to delete. All named ranges with the given name will be deleted.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the range(s) to delete. All named ranges with the given name will be deleted.
   * @param name name or {@code null} for none
   */
  public DeleteNamedRangeRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the named range to delete.
   * @return value or {@code null} for none
   */
  public java.lang.String getNamedRangeId() {
    return namedRangeId;
  }

  /**
   * The ID of the named range to delete.
   * @param namedRangeId namedRangeId or {@code null} for none
   */
  public DeleteNamedRangeRequest setNamedRangeId(java.lang.String namedRangeId) {
    this.namedRangeId = namedRangeId;
    return this;
  }

  /**
   * Optional. The criteria used to specify which tab(s) the range deletion should occur in. When
   * omitted, the range deletion is applied to all tabs. In a document containing a single tab: - If
   * provided, must match the singular tab's ID. - If omitted, the range deletion applies to the
   * singular tab. In a document containing multiple tabs: - If provided, the range deletion applies
   * to the specified tabs. - If not provided, the range deletion applies to all tabs.
   * @return value or {@code null} for none
   */
  public TabsCriteria getTabsCriteria() {
    return tabsCriteria;
  }

  /**
   * Optional. The criteria used to specify which tab(s) the range deletion should occur in. When
   * omitted, the range deletion is applied to all tabs. In a document containing a single tab: - If
   * provided, must match the singular tab's ID. - If omitted, the range deletion applies to the
   * singular tab. In a document containing multiple tabs: - If provided, the range deletion applies
   * to the specified tabs. - If not provided, the range deletion applies to all tabs.
   * @param tabsCriteria tabsCriteria or {@code null} for none
   */
  public DeleteNamedRangeRequest setTabsCriteria(TabsCriteria tabsCriteria) {
    this.tabsCriteria = tabsCriteria;
    return this;
  }

  @Override
  public DeleteNamedRangeRequest set(String fieldName, Object value) {
    return (DeleteNamedRangeRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteNamedRangeRequest clone() {
    return (DeleteNamedRangeRequest) super.clone();
  }

}
