/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Deletes a Header from the document.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DeleteHeaderRequest extends com.google.api.client.json.GenericJson {

  /**
   * The id of the header to delete. If this header is defined on DocumentStyle, the reference to
   * this header is removed, resulting in no header of that type for the first section of the
   * document. If this header is defined on a SectionStyle, the reference to this header is removed
   * and the header of that type is now continued from the previous section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headerId;

  /**
   * The tab containing the header to delete. When omitted, the request is applied to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tabId;

  /**
   * The id of the header to delete. If this header is defined on DocumentStyle, the reference to
   * this header is removed, resulting in no header of that type for the first section of the
   * document. If this header is defined on a SectionStyle, the reference to this header is removed
   * and the header of that type is now continued from the previous section.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeaderId() {
    return headerId;
  }

  /**
   * The id of the header to delete. If this header is defined on DocumentStyle, the reference to
   * this header is removed, resulting in no header of that type for the first section of the
   * document. If this header is defined on a SectionStyle, the reference to this header is removed
   * and the header of that type is now continued from the previous section.
   * @param headerId headerId or {@code null} for none
   */
  public DeleteHeaderRequest setHeaderId(java.lang.String headerId) {
    this.headerId = headerId;
    return this;
  }

  /**
   * The tab containing the header to delete. When omitted, the request is applied to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * @return value or {@code null} for none
   */
  public java.lang.String getTabId() {
    return tabId;
  }

  /**
   * The tab containing the header to delete. When omitted, the request is applied to the first tab.
   * In a document containing a single tab: - If provided, must match the singular tab's ID. - If
   * omitted, the request applies to the singular tab. In a document containing multiple tabs: - If
   * provided, the request applies to the specified tab. - If omitted, the request applies to the
   * first tab in the document.
   * @param tabId tabId or {@code null} for none
   */
  public DeleteHeaderRequest setTabId(java.lang.String tabId) {
    this.tabId = tabId;
    return this;
  }

  @Override
  public DeleteHeaderRequest set(String fieldName, Object value) {
    return (DeleteHeaderRequest) super.set(fieldName, value);
  }

  @Override
  public DeleteHeaderRequest clone() {
    return (DeleteHeaderRequest) super.clone();
  }

}
