/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * A mask that indicates which of the fields on the base Bullet have been changed in this
 * suggestion. For any field set to true, there's a new suggested value.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BulletSuggestionState extends com.google.api.client.json.GenericJson {

  /**
   * Indicates if there was a suggested change to the list_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean listIdSuggested;

  /**
   * Indicates if there was a suggested change to the nesting_level.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean nestingLevelSuggested;

  /**
   * A mask that indicates which of the fields in text style have been changed in this suggestion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyleSuggestionState textStyleSuggestionState;

  /**
   * Indicates if there was a suggested change to the list_id.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getListIdSuggested() {
    return listIdSuggested;
  }

  /**
   * Indicates if there was a suggested change to the list_id.
   * @param listIdSuggested listIdSuggested or {@code null} for none
   */
  public BulletSuggestionState setListIdSuggested(java.lang.Boolean listIdSuggested) {
    this.listIdSuggested = listIdSuggested;
    return this;
  }

  /**
   * Indicates if there was a suggested change to the nesting_level.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNestingLevelSuggested() {
    return nestingLevelSuggested;
  }

  /**
   * Indicates if there was a suggested change to the nesting_level.
   * @param nestingLevelSuggested nestingLevelSuggested or {@code null} for none
   */
  public BulletSuggestionState setNestingLevelSuggested(java.lang.Boolean nestingLevelSuggested) {
    this.nestingLevelSuggested = nestingLevelSuggested;
    return this;
  }

  /**
   * A mask that indicates which of the fields in text style have been changed in this suggestion.
   * @return value or {@code null} for none
   */
  public TextStyleSuggestionState getTextStyleSuggestionState() {
    return textStyleSuggestionState;
  }

  /**
   * A mask that indicates which of the fields in text style have been changed in this suggestion.
   * @param textStyleSuggestionState textStyleSuggestionState or {@code null} for none
   */
  public BulletSuggestionState setTextStyleSuggestionState(TextStyleSuggestionState textStyleSuggestionState) {
    this.textStyleSuggestionState = textStyleSuggestionState;
    return this;
  }

  @Override
  public BulletSuggestionState set(String fieldName, Object value) {
    return (BulletSuggestionState) super.set(fieldName, value);
  }

  @Override
  public BulletSuggestionState clone() {
    return (BulletSuggestionState) super.clone();
  }

}
