/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.docs.v1.model;

/**
 * Describes the bullet of a paragraph.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Docs API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Bullet extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the list this paragraph belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String listId;

  /**
   * The nesting level of this paragraph in the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer nestingLevel;

  /**
   * The paragraph-specific text style applied to this bullet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextStyle textStyle;

  /**
   * The ID of the list this paragraph belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getListId() {
    return listId;
  }

  /**
   * The ID of the list this paragraph belongs to.
   * @param listId listId or {@code null} for none
   */
  public Bullet setListId(java.lang.String listId) {
    this.listId = listId;
    return this;
  }

  /**
   * The nesting level of this paragraph in the list.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNestingLevel() {
    return nestingLevel;
  }

  /**
   * The nesting level of this paragraph in the list.
   * @param nestingLevel nestingLevel or {@code null} for none
   */
  public Bullet setNestingLevel(java.lang.Integer nestingLevel) {
    this.nestingLevel = nestingLevel;
    return this;
  }

  /**
   * The paragraph-specific text style applied to this bullet.
   * @return value or {@code null} for none
   */
  public TextStyle getTextStyle() {
    return textStyle;
  }

  /**
   * The paragraph-specific text style applied to this bullet.
   * @param textStyle textStyle or {@code null} for none
   */
  public Bullet setTextStyle(TextStyle textStyle) {
    this.textStyle = textStyle;
    return this;
  }

  @Override
  public Bullet set(String fieldName, Object value) {
    return (Bullet) super.set(fieldName, value);
  }

  @Override
  public Bullet clone() {
    return (Bullet) super.clone();
  }

}
