/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.displayvideo.v1dev;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.displayvideo.v1dev.DisplayVideoRequest;
import com.google.api.services.displayvideo.v1dev.DisplayVideoRequestInitializer;
import com.google.api.services.displayvideo.v1dev.model.GoogleBytestreamMedia;
import com.google.api.services.displayvideo.v1dev.model.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class DisplayVideo
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://displayvideo.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://displayvideo.googleapis.com/";

    public DisplayVideo(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DisplayVideo(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Media media() {
        return new Media();
    }

    public Sdfdownloadtasks sdfdownloadtasks() {
        return new Sdfdownloadtasks();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.10 of the Display & Video 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://displayvideo.googleapis.com/", DisplayVideo.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DisplayVideo.DEFAULT_BATCH_PATH);
        }

        public DisplayVideo build() {
            return new DisplayVideo(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDisplayVideoRequestInitializer(DisplayVideoRequestInitializer displayvideoRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)displayvideoRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Sdfdownloadtasks {
        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends DisplayVideoRequest<Operation> {
                private static final String REST_PATH = "v1dev/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^sdfdownloadtasks/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }

    public class Media {
        public Download download(String resourceName) throws IOException {
            Download result = new Download(resourceName);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Download
        extends DisplayVideoRequest<GoogleBytestreamMedia> {
            private static final String REST_PATH = "download/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String resourceName) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String resourceName) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }
}

