/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.displayvideo.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.displayvideo.v1.DisplayVideoRequest;
import com.google.api.services.displayvideo.v1.DisplayVideoRequestInitializer;
import com.google.api.services.displayvideo.v1.model.CreateSdfDownloadTaskRequest;
import com.google.api.services.displayvideo.v1.model.GoogleBytestreamMedia;
import com.google.api.services.displayvideo.v1.model.Operation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayVideo
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://displayvideo.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://displayvideo.googleapis.com/";

    public DisplayVideo(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    DisplayVideo(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Media media() {
        return new Media();
    }

    public Sdfdownloadtasks sdfdownloadtasks() {
        return new Sdfdownloadtasks();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Display & Video 360 API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://displayvideo.googleapis.com/", DisplayVideo.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DisplayVideo.DEFAULT_BATCH_PATH);
        }

        public DisplayVideo build() {
            return new DisplayVideo(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDisplayVideoRequestInitializer(DisplayVideoRequestInitializer displayVideoRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)displayVideoRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Sdfdownloadtasks {
        public Create create(CreateSdfDownloadTaskRequest createSdfDownloadTaskRequest) throws IOException {
            Create create = new Create(createSdfDownloadTaskRequest);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)create);
            return create;
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DisplayVideoRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(DisplayVideo.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^sdfdownloadtasks/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!DisplayVideo.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^sdfdownloadtasks/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends DisplayVideoRequest<Operation> {
            private static final String REST_PATH = "v1/sdfdownloadtasks";

            protected Create(CreateSdfDownloadTaskRequest createSdfDownloadTaskRequest) {
                super(DisplayVideo.this, "POST", REST_PATH, (Object)createSdfDownloadTaskRequest, Operation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Media {
        public Download download(String string) throws IOException {
            Download download = new Download(string);
            DisplayVideo.this.initialize((AbstractGoogleClientRequest<?>)download);
            return download;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Download
        extends DisplayVideoRequest<GoogleBytestreamMedia> {
            private static final String REST_PATH = "download/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String string) {
                super(DisplayVideo.this, "GET", REST_PATH, null, GoogleBytestreamMedia.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.*$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resourceName must be specified.");
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String string) {
                return (Download)super.set$Xgafv(string);
            }

            public Download setAccessToken(String string) {
                return (Download)super.setAccessToken(string);
            }

            public Download setAlt(String string) {
                return (Download)super.setAlt(string);
            }

            public Download setCallback(String string) {
                return (Download)super.setCallback(string);
            }

            public Download setFields(String string) {
                return (Download)super.setFields(string);
            }

            public Download setKey(String string) {
                return (Download)super.setKey(string);
            }

            public Download setOauthToken(String string) {
                return (Download)super.setOauthToken(string);
            }

            public Download setPrettyPrint(Boolean bl) {
                return (Download)super.setPrettyPrint(bl);
            }

            public Download setQuotaUser(String string) {
                return (Download)super.setQuotaUser(string);
            }

            public Download setUploadType(String string) {
                return (Download)super.setUploadType(string);
            }

            public Download setUploadProtocol(String string) {
                return (Download)super.setUploadProtocol(string);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String string) {
                if (!DisplayVideo.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(string).matches(), (Object)"Parameter resourceName must conform to the pattern ^.*$");
                }
                this.resourceName = string;
                return this;
            }

            @Override
            public Download set(String string, Object object) {
                return (Download)super.set(string, object);
            }
        }
    }
}

