/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1beta1.model;

/**
 * An entry for an Access Control list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SqlAclEntry extends com.google.api.client.json.GenericJson {

  /**
   * The time when this access control entry expires in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * A label to identify this entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Input only. The time-to-leave of this access control entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String ttl;

  /**
   * The allowlisted value for the access control list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The time when this access control entry expires in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * The time when this access control entry expires in [RFC
   * 3339](https://tools.ietf.org/html/rfc3339) format, for example: `2012-11-15T16:19:00.094Z`.
   * @param expireTime expireTime or {@code null} for none
   */
  public SqlAclEntry setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  /**
   * A label to identify this entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * A label to identify this entry.
   * @param label label or {@code null} for none
   */
  public SqlAclEntry setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  /**
   * Input only. The time-to-leave of this access control entry.
   * @return value or {@code null} for none
   */
  public String getTtl() {
    return ttl;
  }

  /**
   * Input only. The time-to-leave of this access control entry.
   * @param ttl ttl or {@code null} for none
   */
  public SqlAclEntry setTtl(String ttl) {
    this.ttl = ttl;
    return this;
  }

  /**
   * The allowlisted value for the access control list.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The allowlisted value for the access control list.
   * @param value value or {@code null} for none
   */
  public SqlAclEntry setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public SqlAclEntry set(String fieldName, Object value) {
    return (SqlAclEntry) super.set(fieldName, value);
  }

  @Override
  public SqlAclEntry clone() {
    return (SqlAclEntry) super.clone();
  }

}
