/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1beta1.model;

/**
 * A message defining the database engine and provider.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DatabaseType extends com.google.api.client.json.GenericJson {

  /**
   * The database engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String engine;

  /**
   * The database provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String provider;

  /**
   * The database engine.
   * @return value or {@code null} for none
   */
  public java.lang.String getEngine() {
    return engine;
  }

  /**
   * The database engine.
   * @param engine engine or {@code null} for none
   */
  public DatabaseType setEngine(java.lang.String engine) {
    this.engine = engine;
    return this;
  }

  /**
   * The database provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getProvider() {
    return provider;
  }

  /**
   * The database provider.
   * @param provider provider or {@code null} for none
   */
  public DatabaseType setProvider(java.lang.String provider) {
    this.provider = provider;
    return this;
  }

  @Override
  public DatabaseType set(String fieldName, Object value) {
    return (DatabaseType) super.set(fieldName, value);
  }

  @Override
  public DatabaseType clone() {
    return (DatabaseType) super.clone();
  }

}
