/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1beta1.model;

/**
 * SSL configuration information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SslConfig extends com.google.api.client.json.GenericJson {

  /**
   * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source
   * database server's certificate. The replica will use this certificate to verify it's connecting
   * to the right host.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String caCertificate;

  /**
   * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate
   * against the source database server.If this field is used then the 'client_key' field is
   * mandatory.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientCertificate;

  /**
   * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client
   * Certificate. If this field is used then the 'client_certificate' field is mandatory.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String clientKey;

  /**
   * Output only. The ssl config type according to 'client_key', 'client_certificate' and
   * 'ca_certificate'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source
   * database server's certificate. The replica will use this certificate to verify it's connecting
   * to the right host.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaCertificate() {
    return caCertificate;
  }

  /**
   * Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source
   * database server's certificate. The replica will use this certificate to verify it's connecting
   * to the right host.
   * @param caCertificate caCertificate or {@code null} for none
   */
  public SslConfig setCaCertificate(java.lang.String caCertificate) {
    this.caCertificate = caCertificate;
    return this;
  }

  /**
   * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate
   * against the source database server.If this field is used then the 'client_key' field is
   * mandatory.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientCertificate() {
    return clientCertificate;
  }

  /**
   * Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate
   * against the source database server.If this field is used then the 'client_key' field is
   * mandatory.
   * @param clientCertificate clientCertificate or {@code null} for none
   */
  public SslConfig setClientCertificate(java.lang.String clientCertificate) {
    this.clientCertificate = clientCertificate;
    return this;
  }

  /**
   * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client
   * Certificate. If this field is used then the 'client_certificate' field is mandatory.
   * @return value or {@code null} for none
   */
  public java.lang.String getClientKey() {
    return clientKey;
  }

  /**
   * Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client
   * Certificate. If this field is used then the 'client_certificate' field is mandatory.
   * @param clientKey clientKey or {@code null} for none
   */
  public SslConfig setClientKey(java.lang.String clientKey) {
    this.clientKey = clientKey;
    return this;
  }

  /**
   * Output only. The ssl config type according to 'client_key', 'client_certificate' and
   * 'ca_certificate'.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. The ssl config type according to 'client_key', 'client_certificate' and
   * 'ca_certificate'.
   * @param type type or {@code null} for none
   */
  public SslConfig setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SslConfig set(String fieldName, Object value) {
    return (SslConfig) super.set(fieldName, value);
  }

  @Override
  public SslConfig clone() {
    return (SslConfig) super.clone();
  }

}
