/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.datamigration.v1beta1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.datamigration.v1beta1.DatabaseMigrationServiceRequest;
import com.google.api.services.datamigration.v1beta1.DatabaseMigrationServiceRequestInitializer;
import com.google.api.services.datamigration.v1beta1.model.CancelOperationRequest;
import com.google.api.services.datamigration.v1beta1.model.ConnectionProfile;
import com.google.api.services.datamigration.v1beta1.model.Empty;
import com.google.api.services.datamigration.v1beta1.model.GenerateSshScriptRequest;
import com.google.api.services.datamigration.v1beta1.model.ListConnectionProfilesResponse;
import com.google.api.services.datamigration.v1beta1.model.ListLocationsResponse;
import com.google.api.services.datamigration.v1beta1.model.ListMigrationJobsResponse;
import com.google.api.services.datamigration.v1beta1.model.ListOperationsResponse;
import com.google.api.services.datamigration.v1beta1.model.Location;
import com.google.api.services.datamigration.v1beta1.model.MigrationJob;
import com.google.api.services.datamigration.v1beta1.model.Operation;
import com.google.api.services.datamigration.v1beta1.model.Policy;
import com.google.api.services.datamigration.v1beta1.model.PromoteMigrationJobRequest;
import com.google.api.services.datamigration.v1beta1.model.RestartMigrationJobRequest;
import com.google.api.services.datamigration.v1beta1.model.ResumeMigrationJobRequest;
import com.google.api.services.datamigration.v1beta1.model.SetIamPolicyRequest;
import com.google.api.services.datamigration.v1beta1.model.SshScript;
import com.google.api.services.datamigration.v1beta1.model.StartMigrationJobRequest;
import com.google.api.services.datamigration.v1beta1.model.StopMigrationJobRequest;
import com.google.api.services.datamigration.v1beta1.model.TestIamPermissionsRequest;
import com.google.api.services.datamigration.v1beta1.model.TestIamPermissionsResponse;
import com.google.api.services.datamigration.v1beta1.model.VerifyMigrationJobRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class DatabaseMigrationService
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://datamigration.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://datamigration.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://datamigration.googleapis.com/";

    public DatabaseMigrationService(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    DatabaseMigrationService(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.31.0 of the Database Migration API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return DatabaseMigrationService.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://datamigration.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), DatabaseMigrationService.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(DatabaseMigrationService.DEFAULT_BATCH_PATH);
        }

        public DatabaseMigrationService build() {
            return new DatabaseMigrationService(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setDatabaseMigrationServiceRequestInitializer(DatabaseMigrationServiceRequestInitializer databasemigrationserviceRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)databasemigrationserviceRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ConnectionProfiles connectionProfiles() {
                return new ConnectionProfiles();
            }

            public MigrationJobs migrationJobs() {
                return new MigrationJobs();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends DatabaseMigrationServiceRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v1beta1/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DatabaseMigrationServiceRequest<Empty> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends DatabaseMigrationServiceRequest<Empty> {
                    private static final String REST_PATH = "v1beta1/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class MigrationJobs {
                public Create create(String parent, MigrationJob content) throws IOException {
                    Create result = new Create(parent, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GenerateSshScript generateSshScript(String migrationJob, GenerateSshScriptRequest content) throws IOException {
                    GenerateSshScript result = new GenerateSshScript(migrationJob, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, MigrationJob content) throws IOException {
                    Patch result = new Patch(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Promote promote(String name, PromoteMigrationJobRequest content) throws IOException {
                    Promote result = new Promote(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Restart restart(String name, RestartMigrationJobRequest content) throws IOException {
                    Restart result = new Restart(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Resume resume(String name, ResumeMigrationJobRequest content) throws IOException {
                    Resume result = new Resume(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Start start(String name, StartMigrationJobRequest content) throws IOException {
                    Start result = new Start(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Stop stop(String name, StopMigrationJobRequest content) throws IOException {
                    Stop result = new Stop(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Verify verify(String name, VerifyMigrationJobRequest content) throws IOException {
                    Verify result = new Verify(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Verify
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:verify";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Verify(String name, VerifyMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Verify set$Xgafv(String $Xgafv) {
                        return (Verify)super.set$Xgafv($Xgafv);
                    }

                    public Verify setAccessToken(String accessToken) {
                        return (Verify)super.setAccessToken(accessToken);
                    }

                    public Verify setAlt(String alt) {
                        return (Verify)super.setAlt(alt);
                    }

                    public Verify setCallback(String callback) {
                        return (Verify)super.setCallback(callback);
                    }

                    public Verify setFields(String fields) {
                        return (Verify)super.setFields(fields);
                    }

                    public Verify setKey(String key) {
                        return (Verify)super.setKey(key);
                    }

                    public Verify setOauthToken(String oauthToken) {
                        return (Verify)super.setOauthToken(oauthToken);
                    }

                    public Verify setPrettyPrint(Boolean prettyPrint) {
                        return (Verify)super.setPrettyPrint(prettyPrint);
                    }

                    public Verify setQuotaUser(String quotaUser) {
                        return (Verify)super.setQuotaUser(quotaUser);
                    }

                    public Verify setUploadType(String uploadType) {
                        return (Verify)super.setUploadType(uploadType);
                    }

                    public Verify setUploadProtocol(String uploadProtocol) {
                        return (Verify)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Verify setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Verify set(String parameterName, Object value) {
                        return (Verify)super.set(parameterName, value);
                    }
                }

                public class TestIamPermissions
                extends DatabaseMigrationServiceRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class Stop
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:stop";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Stop(String name, StopMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Stop set$Xgafv(String $Xgafv) {
                        return (Stop)super.set$Xgafv($Xgafv);
                    }

                    public Stop setAccessToken(String accessToken) {
                        return (Stop)super.setAccessToken(accessToken);
                    }

                    public Stop setAlt(String alt) {
                        return (Stop)super.setAlt(alt);
                    }

                    public Stop setCallback(String callback) {
                        return (Stop)super.setCallback(callback);
                    }

                    public Stop setFields(String fields) {
                        return (Stop)super.setFields(fields);
                    }

                    public Stop setKey(String key) {
                        return (Stop)super.setKey(key);
                    }

                    public Stop setOauthToken(String oauthToken) {
                        return (Stop)super.setOauthToken(oauthToken);
                    }

                    public Stop setPrettyPrint(Boolean prettyPrint) {
                        return (Stop)super.setPrettyPrint(prettyPrint);
                    }

                    public Stop setQuotaUser(String quotaUser) {
                        return (Stop)super.setQuotaUser(quotaUser);
                    }

                    public Stop setUploadType(String uploadType) {
                        return (Stop)super.setUploadType(uploadType);
                    }

                    public Stop setUploadProtocol(String uploadProtocol) {
                        return (Stop)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Stop setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Stop set(String parameterName, Object value) {
                        return (Stop)super.set(parameterName, value);
                    }
                }

                public class Start
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:start";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Start(String name, StartMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Start set$Xgafv(String $Xgafv) {
                        return (Start)super.set$Xgafv($Xgafv);
                    }

                    public Start setAccessToken(String accessToken) {
                        return (Start)super.setAccessToken(accessToken);
                    }

                    public Start setAlt(String alt) {
                        return (Start)super.setAlt(alt);
                    }

                    public Start setCallback(String callback) {
                        return (Start)super.setCallback(callback);
                    }

                    public Start setFields(String fields) {
                        return (Start)super.setFields(fields);
                    }

                    public Start setKey(String key) {
                        return (Start)super.setKey(key);
                    }

                    public Start setOauthToken(String oauthToken) {
                        return (Start)super.setOauthToken(oauthToken);
                    }

                    public Start setPrettyPrint(Boolean prettyPrint) {
                        return (Start)super.setPrettyPrint(prettyPrint);
                    }

                    public Start setQuotaUser(String quotaUser) {
                        return (Start)super.setQuotaUser(quotaUser);
                    }

                    public Start setUploadType(String uploadType) {
                        return (Start)super.setUploadType(uploadType);
                    }

                    public Start setUploadProtocol(String uploadProtocol) {
                        return (Start)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Start setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Start set(String parameterName, Object value) {
                        return (Start)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends DatabaseMigrationServiceRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Resume
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:resume";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Resume(String name, ResumeMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Resume set$Xgafv(String $Xgafv) {
                        return (Resume)super.set$Xgafv($Xgafv);
                    }

                    public Resume setAccessToken(String accessToken) {
                        return (Resume)super.setAccessToken(accessToken);
                    }

                    public Resume setAlt(String alt) {
                        return (Resume)super.setAlt(alt);
                    }

                    public Resume setCallback(String callback) {
                        return (Resume)super.setCallback(callback);
                    }

                    public Resume setFields(String fields) {
                        return (Resume)super.setFields(fields);
                    }

                    public Resume setKey(String key) {
                        return (Resume)super.setKey(key);
                    }

                    public Resume setOauthToken(String oauthToken) {
                        return (Resume)super.setOauthToken(oauthToken);
                    }

                    public Resume setPrettyPrint(Boolean prettyPrint) {
                        return (Resume)super.setPrettyPrint(prettyPrint);
                    }

                    public Resume setQuotaUser(String quotaUser) {
                        return (Resume)super.setQuotaUser(quotaUser);
                    }

                    public Resume setUploadType(String uploadType) {
                        return (Resume)super.setUploadType(uploadType);
                    }

                    public Resume setUploadProtocol(String uploadProtocol) {
                        return (Resume)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Resume setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Resume set(String parameterName, Object value) {
                        return (Resume)super.set(parameterName, value);
                    }
                }

                public class Restart
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:restart";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Restart(String name, RestartMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Restart set$Xgafv(String $Xgafv) {
                        return (Restart)super.set$Xgafv($Xgafv);
                    }

                    public Restart setAccessToken(String accessToken) {
                        return (Restart)super.setAccessToken(accessToken);
                    }

                    public Restart setAlt(String alt) {
                        return (Restart)super.setAlt(alt);
                    }

                    public Restart setCallback(String callback) {
                        return (Restart)super.setCallback(callback);
                    }

                    public Restart setFields(String fields) {
                        return (Restart)super.setFields(fields);
                    }

                    public Restart setKey(String key) {
                        return (Restart)super.setKey(key);
                    }

                    public Restart setOauthToken(String oauthToken) {
                        return (Restart)super.setOauthToken(oauthToken);
                    }

                    public Restart setPrettyPrint(Boolean prettyPrint) {
                        return (Restart)super.setPrettyPrint(prettyPrint);
                    }

                    public Restart setQuotaUser(String quotaUser) {
                        return (Restart)super.setQuotaUser(quotaUser);
                    }

                    public Restart setUploadType(String uploadType) {
                        return (Restart)super.setUploadType(uploadType);
                    }

                    public Restart setUploadProtocol(String uploadProtocol) {
                        return (Restart)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Restart setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Restart set(String parameterName, Object value) {
                        return (Restart)super.set(parameterName, value);
                    }
                }

                public class Promote
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}:promote";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Promote(String name, PromoteMigrationJobRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Promote set$Xgafv(String $Xgafv) {
                        return (Promote)super.set$Xgafv($Xgafv);
                    }

                    public Promote setAccessToken(String accessToken) {
                        return (Promote)super.setAccessToken(accessToken);
                    }

                    public Promote setAlt(String alt) {
                        return (Promote)super.setAlt(alt);
                    }

                    public Promote setCallback(String callback) {
                        return (Promote)super.setCallback(callback);
                    }

                    public Promote setFields(String fields) {
                        return (Promote)super.setFields(fields);
                    }

                    public Promote setKey(String key) {
                        return (Promote)super.setKey(key);
                    }

                    public Promote setOauthToken(String oauthToken) {
                        return (Promote)super.setOauthToken(oauthToken);
                    }

                    public Promote setPrettyPrint(Boolean prettyPrint) {
                        return (Promote)super.setPrettyPrint(prettyPrint);
                    }

                    public Promote setQuotaUser(String quotaUser) {
                        return (Promote)super.setQuotaUser(quotaUser);
                    }

                    public Promote setUploadType(String uploadType) {
                        return (Promote)super.setUploadType(uploadType);
                    }

                    public Promote setUploadProtocol(String uploadProtocol) {
                        return (Promote)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Promote setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Promote set(String parameterName, Object value) {
                        return (Promote)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;

                    protected Patch(String name, MigrationJob content) {
                        super(DatabaseMigrationService.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends DatabaseMigrationServiceRequest<ListMigrationJobsResponse> {
                    private static final String REST_PATH = "v1beta1/{+parent}/migrationJobs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, ListMigrationJobsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends DatabaseMigrationServiceRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DatabaseMigrationServiceRequest<MigrationJob> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, MigrationJob.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class GenerateSshScript
                extends DatabaseMigrationServiceRequest<SshScript> {
                    private static final String REST_PATH = "v1beta1/{+migrationJob}:generateSshScript";
                    private final Pattern MIGRATION_JOB_PATTERN;
                    @Key
                    private String migrationJob;

                    protected GenerateSshScript(String migrationJob, GenerateSshScriptRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, SshScript.class);
                        this.MIGRATION_JOB_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.migrationJob = (String)Preconditions.checkNotNull((Object)migrationJob, (Object)"Required parameter migrationJob must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.MIGRATION_JOB_PATTERN.matcher(migrationJob).matches(), (Object)"Parameter migrationJob must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public GenerateSshScript set$Xgafv(String $Xgafv) {
                        return (GenerateSshScript)super.set$Xgafv($Xgafv);
                    }

                    public GenerateSshScript setAccessToken(String accessToken) {
                        return (GenerateSshScript)super.setAccessToken(accessToken);
                    }

                    public GenerateSshScript setAlt(String alt) {
                        return (GenerateSshScript)super.setAlt(alt);
                    }

                    public GenerateSshScript setCallback(String callback) {
                        return (GenerateSshScript)super.setCallback(callback);
                    }

                    public GenerateSshScript setFields(String fields) {
                        return (GenerateSshScript)super.setFields(fields);
                    }

                    public GenerateSshScript setKey(String key) {
                        return (GenerateSshScript)super.setKey(key);
                    }

                    public GenerateSshScript setOauthToken(String oauthToken) {
                        return (GenerateSshScript)super.setOauthToken(oauthToken);
                    }

                    public GenerateSshScript setPrettyPrint(Boolean prettyPrint) {
                        return (GenerateSshScript)super.setPrettyPrint(prettyPrint);
                    }

                    public GenerateSshScript setQuotaUser(String quotaUser) {
                        return (GenerateSshScript)super.setQuotaUser(quotaUser);
                    }

                    public GenerateSshScript setUploadType(String uploadType) {
                        return (GenerateSshScript)super.setUploadType(uploadType);
                    }

                    public GenerateSshScript setUploadProtocol(String uploadProtocol) {
                        return (GenerateSshScript)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getMigrationJob() {
                        return this.migrationJob;
                    }

                    public GenerateSshScript setMigrationJob(String migrationJob) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.MIGRATION_JOB_PATTERN.matcher(migrationJob).matches(), (Object)"Parameter migrationJob must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.migrationJob = migrationJob;
                        return this;
                    }

                    @Override
                    public GenerateSshScript set(String parameterName, Object value) {
                        return (GenerateSshScript)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean force;
                    @Key
                    private String requestId;

                    protected Delete(String name) {
                        super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getForce() {
                        return this.force;
                    }

                    public Delete setForce(Boolean force) {
                        this.force = force;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+parent}/migrationJobs";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String migrationJobId;
                    @Key
                    private String requestId;

                    protected Create(String parent, MigrationJob content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getMigrationJobId() {
                        return this.migrationJobId;
                    }

                    public Create setMigrationJobId(String migrationJobId) {
                        this.migrationJobId = migrationJobId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class ConnectionProfiles {
                public Create create(String parent, ConnectionProfile content) throws IOException {
                    Create result = new Create(parent, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, ConnectionProfile content) throws IOException {
                    Patch result = new Patch(name, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    DatabaseMigrationService.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class TestIamPermissions
                extends DatabaseMigrationServiceRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends DatabaseMigrationServiceRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;

                    protected Patch(String name, ConnectionProfile content) {
                        super(DatabaseMigrationService.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends DatabaseMigrationServiceRequest<ListConnectionProfilesResponse> {
                    private static final String REST_PATH = "v1beta1/{+parent}/connectionProfiles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, ListConnectionProfilesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends DatabaseMigrationServiceRequest<Policy> {
                    private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Get
                extends DatabaseMigrationServiceRequest<ConnectionProfile> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(DatabaseMigrationService.this, "GET", REST_PATH, null, ConnectionProfile.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private Boolean force;
                    @Key
                    private String requestId;

                    protected Delete(String name) {
                        super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public Boolean getForce() {
                        return this.force;
                    }

                    public Delete setForce(Boolean force) {
                        this.force = force;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends DatabaseMigrationServiceRequest<Operation> {
                    private static final String REST_PATH = "v1beta1/{+parent}/connectionProfiles";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String connectionProfileId;
                    @Key
                    private String requestId;

                    protected Create(String parent, ConnectionProfile content) {
                        super(DatabaseMigrationService.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getConnectionProfileId() {
                        return this.connectionProfileId;
                    }

                    public Create setConnectionProfileId(String connectionProfileId) {
                        this.connectionProfileId = connectionProfileId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends DatabaseMigrationServiceRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v1beta1/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(DatabaseMigrationService.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends DatabaseMigrationServiceRequest<Location> {
                private static final String REST_PATH = "v1beta1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(DatabaseMigrationService.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!DatabaseMigrationService.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

