# Database Migration API Client Library for Java

Manage Cloud Database Migration Service resources on Google Cloud Platform.

This page contains information about getting started with the Database Migration API
using the Google API Client Library for Java. In addition, you may be interested
in the following documentation:

* Browse the [Javadoc reference for the Database Migration API][javadoc]
* Read the [Developer's Guide for the Google API Client Library for Java][google-api-client].
* Interact with this API in your browser using the [APIs Explorer for the Database Migration API][api-explorer]

## Installation

### Maven

Add the following lines to your `pom.xml` file:

```xml
<project>
  <dependencies>
    <dependency>
      <groupId>com.google.apis</groupId>
      <artifactId>google-api-services-datamigration</artifactId>
      <version>v1beta1-rev20210307-1.31.0</version>
    </dependency>
  </dependencies>
</project>
```

### Gradle

```gradle
repositories {
  mavenCentral()
}
dependencies {
  compile 'com.google.apis:google-api-services-datamigration:v1beta1-rev20210307-1.31.0'
}
```

[javadoc]: https://googleapis.dev/java/google-api-services-datamigration/latest/index.html
[google-api-client]: https://github.com/googleapis/google-api-java-client/
[api-explorer]: https://developers.google.com/apis-explorer/#p/datamigration/v1/
