/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1;

/**
 * Service definition for DatabaseMigrationService (v1).
 *
 * <p>
 * Manage Cloud Database Migration Service resources on Google Cloud Platform.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/database-migration/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DatabaseMigrationServiceRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class DatabaseMigrationService extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Database Migration API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://datamigration.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://datamigration.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public DatabaseMigrationService(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  DatabaseMigrationService(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code DatabaseMigrationService datamigration = new DatabaseMigrationService(...);}
   *   {@code DatabaseMigrationService.Projects.List request = datamigration.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code DatabaseMigrationService datamigration = new DatabaseMigrationService(...);}
     *   {@code DatabaseMigrationService.Locations.List request = datamigration.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Gets information about a location.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the datamigration server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Resource name for the location.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Location> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Gets information about a location.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the datamigration server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name for the location.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name for the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name for the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name for the location. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists information about the supported locations for this service.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the datamigration server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The resource that owns the locations collection, if applicable.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.ListLocationsResponse> {

        private static final String REST_PATH = "v1/{+name}/locations";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists information about the supported locations for this service.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the datamigration server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource that owns the locations collection, if applicable.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.ListLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource that owns the locations collection, if applicable. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource that owns the locations collection, if applicable.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource that owns the locations collection, if applicable. */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A filter to narrow down results to a preferred subset. The filtering language accepts strings like
       "displayName=tokyo", and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return. If not set, the service selects a default.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token received from the `next_page_token` field in the response. Send that page token to
       receive the subsequent page.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the ConnectionProfiles collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code DatabaseMigrationService datamigration = new DatabaseMigrationService(...);}
       *   {@code DatabaseMigrationService.ConnectionProfiles.List request = datamigration.connectionProfiles().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public ConnectionProfiles connectionProfiles() {
        return new ConnectionProfiles();
      }

      /**
       * The "connectionProfiles" collection of methods.
       */
      public class ConnectionProfiles {

        /**
         * Creates a new connection profile in a given project and location.
         *
         * Create a request for the method "connectionProfiles.create".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The parent, which owns this collection of connection profiles.
         * @param content the {@link com.google.api.services.datamigration.v1.model.ConnectionProfile}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.datamigration.v1.model.ConnectionProfile content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/connectionProfiles";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new connection profile in a given project and location.
           *
           * Create a request for the method "connectionProfiles.create".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The parent, which owns this collection of connection profiles.
           * @param content the {@link com.google.api.services.datamigration.v1.model.ConnectionProfile}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.datamigration.v1.model.ConnectionProfile content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The parent, which owns this collection of connection profiles. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The parent, which owns this collection of connection profiles.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The parent, which owns this collection of connection profiles. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. The connection profile identifier. */
          @com.google.api.client.util.Key
          private java.lang.String connectionProfileId;

          /** Required. The connection profile identifier.
           */
          public java.lang.String getConnectionProfileId() {
            return connectionProfileId;
          }

          /** Required. The connection profile identifier. */
          public Create setConnectionProfileId(java.lang.String connectionProfileId) {
            this.connectionProfileId = connectionProfileId;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Create setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a single Database Migration Service connection profile. A connection profile can only be
         * deleted if it is not in use by any active migration jobs.
         *
         * Create a request for the method "connectionProfiles.delete".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the connection profile resource to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Deletes a single Database Migration Service connection profile. A connection profile can only
           * be deleted if it is not in use by any active migration jobs.
           *
           * Create a request for the method "connectionProfiles.delete".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the connection profile resource to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Name of the connection profile resource to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the connection profile resource to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. Name of the connection profile resource to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * In case of force delete, the CloudSQL replica database is also deleted (only for
           * CloudSQL connection profile).
           */
          @com.google.api.client.util.Key
          private java.lang.Boolean force;

          /** In case of force delete, the CloudSQL replica database is also deleted (only for CloudSQL
         connection profile).
           */
          public java.lang.Boolean getForce() {
            return force;
          }

          /**
           * In case of force delete, the CloudSQL replica database is also deleted (only for
           * CloudSQL connection profile).
           */
          public Delete setForce(java.lang.Boolean force) {
            this.force = force;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Delete setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of a single connection profile.
         *
         * Create a request for the method "connectionProfiles.get".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the connection profile resource to get.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.ConnectionProfile> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Gets details of a single connection profile.
           *
           * Create a request for the method "connectionProfiles.get".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the connection profile resource to get.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.ConnectionProfile.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Name of the connection profile resource to get. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the connection profile resource to get.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. Name of the connection profile resource to get. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "connectionProfiles.getIamPolicy".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "connectionProfiles.getIamPolicy".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
         specifying an invalid value will be rejected. Requests for policies with any conditional bindings
         must specify version 3. Policies without any conditional bindings may specify any valid value or
         leave the field unset. To learn which resources support conditions in their IAM policies, see the
         [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Retrieve a list of all connection profiles in a given project and location.
         *
         * Create a request for the method "connectionProfiles.list".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The parent, which owns this collection of connection profiles.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.ListConnectionProfilesResponse> {

          private static final String REST_PATH = "v1/{+parent}/connectionProfiles";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Retrieve a list of all connection profiles in a given project and location.
           *
           * Create a request for the method "connectionProfiles.list".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The parent, which owns this collection of connection profiles.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.ListConnectionProfilesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The parent, which owns this collection of connection profiles. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The parent, which owns this collection of connection profiles.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The parent, which owns this collection of connection profiles. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A filter expression that filters connection profiles listed in the response. The
           * expression must specify the field name, a comparison operator, and the value that you
           * want to use for filtering. The value must be a string, a number, or a boolean. The
           * comparison operator must be either =, !=, >, or <. For example, list connection
           * profiles created this year by specifying **createTime %gt;
           * 2020-01-01T00:00:00.000000000Z**. You can also filter nested fields. For example, you
           * could specify **mySql.username = %lt;my_username%gt;** to list all connection profiles
           * configured to connect with a specific username.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** A filter expression that filters connection profiles listed in the response. The expression must
         specify the field name, a comparison operator, and the value that you want to use for filtering.
         The value must be a string, a number, or a boolean. The comparison operator must be either =, !=,
         >, or <. For example, list connection profiles created this year by specifying **createTime %gt;
         2020-01-01T00:00:00.000000000Z**. You can also filter nested fields. For example, you could specify
         **mySql.username = %lt;my_username%gt;** to list all connection profiles configured to connect with
         a specific username.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * A filter expression that filters connection profiles listed in the response. The
           * expression must specify the field name, a comparison operator, and the value that you
           * want to use for filtering. The value must be a string, a number, or a boolean. The
           * comparison operator must be either =, !=, >, or <. For example, list connection
           * profiles created this year by specifying **createTime %gt;
           * 2020-01-01T00:00:00.000000000Z**. You can also filter nested fields. For example, you
           * could specify **mySql.username = %lt;my_username%gt;** to list all connection profiles
           * configured to connect with a specific username.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** the order by fields for the result. */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** the order by fields for the result.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /** the order by fields for the result. */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /**
           * The maximum number of connection profiles to return. The service may return fewer than
           * this value. If unspecified, at most 50 connection profiles will be returned. The
           * maximum value is 1000; values above 1000 will be coerced to 1000.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of connection profiles to return. The service may return fewer than this value.
         If unspecified, at most 50 connection profiles will be returned. The maximum value is 1000; values
         above 1000 will be coerced to 1000.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of connection profiles to return. The service may return fewer than
           * this value. If unspecified, at most 50 connection profiles will be returned. The
           * maximum value is 1000; values above 1000 will be coerced to 1000.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A page token, received from a previous `ListConnectionProfiles` call. Provide this to
           * retrieve the subsequent page. When paginating, all other parameters provided to
           * `ListConnectionProfiles` must match the call that provided the page token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A page token, received from a previous `ListConnectionProfiles` call. Provide this to retrieve the
         subsequent page. When paginating, all other parameters provided to `ListConnectionProfiles` must
         match the call that provided the page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A page token, received from a previous `ListConnectionProfiles` call. Provide this to
           * retrieve the subsequent page. When paginating, all other parameters provided to
           * `ListConnectionProfiles` must match the call that provided the page token.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Update the configuration of a single connection profile.
         *
         * Create a request for the method "connectionProfiles.patch".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The name of this connection profile resource in the form of
         *        projects/{project}/locations/{location}/connectionProfiles/{instance}.
         * @param content the {@link com.google.api.services.datamigration.v1.model.ConnectionProfile}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.datamigration.v1.model.ConnectionProfile content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Update the configuration of a single connection profile.
           *
           * Create a request for the method "connectionProfiles.patch".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of this connection profile resource in the form of
         *        projects/{project}/locations/{location}/connectionProfiles/{instance}.
           * @param content the {@link com.google.api.services.datamigration.v1.model.ConnectionProfile}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.datamigration.v1.model.ConnectionProfile content) {
            super(DatabaseMigrationService.this, "PATCH", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name of this connection profile resource in the form of
           * projects/{project}/locations/{location}/connectionProfiles/{instance}.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of this connection profile resource in the form of
         projects/{project}/locations/{location}/connectionProfiles/{instance}.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name of this connection profile resource in the form of
           * projects/{project}/locations/{location}/connectionProfiles/{instance}.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Patch setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          /**
           * Required. Field mask is used to specify the fields to be overwritten in the connection
           * profile resource by the update.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** Required. Field mask is used to specify the fields to be overwritten in the connection profile
         resource by the update.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * Required. Field mask is used to specify the fields to be overwritten in the connection
           * profile resource by the update.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "connectionProfiles.setIamPolicy".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.datamigration.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.datamigration.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "connectionProfiles.setIamPolicy".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.datamigration.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.datamigration.v1.model.SetIamPolicyRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
         * designed to be used for building permission-aware UIs and command-line tools, not for
         * authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "connectionProfiles.testIamPermissions".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
           * operation is designed to be used for building permission-aware UIs and command-line tools, not
           * for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "connectionProfiles.testIamPermissions".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/connectionProfiles/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the MigrationJobs collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code DatabaseMigrationService datamigration = new DatabaseMigrationService(...);}
       *   {@code DatabaseMigrationService.MigrationJobs.List request = datamigration.migrationJobs().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public MigrationJobs migrationJobs() {
        return new MigrationJobs();
      }

      /**
       * The "migrationJobs" collection of methods.
       */
      public class MigrationJobs {

        /**
         * Creates a new migration job in a given project and location.
         *
         * Create a request for the method "migrationJobs.create".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The parent, which owns this collection of migration jobs.
         * @param content the {@link com.google.api.services.datamigration.v1.model.MigrationJob}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.datamigration.v1.model.MigrationJob content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/migrationJobs";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new migration job in a given project and location.
           *
           * Create a request for the method "migrationJobs.create".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The parent, which owns this collection of migration jobs.
           * @param content the {@link com.google.api.services.datamigration.v1.model.MigrationJob}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.datamigration.v1.model.MigrationJob content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The parent, which owns this collection of migration jobs. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The parent, which owns this collection of migration jobs.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The parent, which owns this collection of migration jobs. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. The ID of the instance to create. */
          @com.google.api.client.util.Key
          private java.lang.String migrationJobId;

          /** Required. The ID of the instance to create.
           */
          public java.lang.String getMigrationJobId() {
            return migrationJobId;
          }

          /** Required. The ID of the instance to create. */
          public Create setMigrationJobId(java.lang.String migrationJobId) {
            this.migrationJobId = migrationJobId;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Create setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a single migration job.
         *
         * Create a request for the method "migrationJobs.delete".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the migration job resource to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Deletes a single migration job.
           *
           * Create a request for the method "migrationJobs.delete".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the migration job resource to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Name of the migration job resource to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the migration job resource to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. Name of the migration job resource to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The destination CloudSQL connection profile is always deleted with the migration job.
           * In case of force delete, the destination CloudSQL replica database is also deleted.
           */
          @com.google.api.client.util.Key
          private java.lang.Boolean force;

          /** The destination CloudSQL connection profile is always deleted with the migration job. In case of
         force delete, the destination CloudSQL replica database is also deleted.
           */
          public java.lang.Boolean getForce() {
            return force;
          }

          /**
           * The destination CloudSQL connection profile is always deleted with the migration job.
           * In case of force delete, the destination CloudSQL replica database is also deleted.
           */
          public Delete setForce(java.lang.Boolean force) {
            this.force = force;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Delete setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Generate a SSH configuration script to configure the reverse SSH connectivity.
         *
         * Create a request for the method "migrationJobs.generateSshScript".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link GenerateSshScript#execute()} method to invoke the remote operation.
         *
         * @param migrationJob Name of the migration job resource to generate the SSH script.
         * @param content the {@link com.google.api.services.datamigration.v1.model.GenerateSshScriptRequest}
         * @return the request
         */
        public GenerateSshScript generateSshScript(java.lang.String migrationJob, com.google.api.services.datamigration.v1.model.GenerateSshScriptRequest content) throws java.io.IOException {
          GenerateSshScript result = new GenerateSshScript(migrationJob, content);
          initialize(result);
          return result;
        }

        public class GenerateSshScript extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.SshScript> {

          private static final String REST_PATH = "v1/{+migrationJob}:generateSshScript";

          private final java.util.regex.Pattern MIGRATION_JOB_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Generate a SSH configuration script to configure the reverse SSH connectivity.
           *
           * Create a request for the method "migrationJobs.generateSshScript".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link GenerateSshScript#execute()} method to invoke the remote
           * operation. <p> {@link GenerateSshScript#initialize(com.google.api.client.googleapis.services.Ab
           * stractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param migrationJob Name of the migration job resource to generate the SSH script.
           * @param content the {@link com.google.api.services.datamigration.v1.model.GenerateSshScriptRequest}
           * @since 1.13
           */
          protected GenerateSshScript(java.lang.String migrationJob, com.google.api.services.datamigration.v1.model.GenerateSshScriptRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.SshScript.class);
            this.migrationJob = com.google.api.client.util.Preconditions.checkNotNull(migrationJob, "Required parameter migrationJob must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(MIGRATION_JOB_PATTERN.matcher(migrationJob).matches(),
                  "Parameter migrationJob must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public GenerateSshScript set$Xgafv(java.lang.String $Xgafv) {
            return (GenerateSshScript) super.set$Xgafv($Xgafv);
          }

          @Override
          public GenerateSshScript setAccessToken(java.lang.String accessToken) {
            return (GenerateSshScript) super.setAccessToken(accessToken);
          }

          @Override
          public GenerateSshScript setAlt(java.lang.String alt) {
            return (GenerateSshScript) super.setAlt(alt);
          }

          @Override
          public GenerateSshScript setCallback(java.lang.String callback) {
            return (GenerateSshScript) super.setCallback(callback);
          }

          @Override
          public GenerateSshScript setFields(java.lang.String fields) {
            return (GenerateSshScript) super.setFields(fields);
          }

          @Override
          public GenerateSshScript setKey(java.lang.String key) {
            return (GenerateSshScript) super.setKey(key);
          }

          @Override
          public GenerateSshScript setOauthToken(java.lang.String oauthToken) {
            return (GenerateSshScript) super.setOauthToken(oauthToken);
          }

          @Override
          public GenerateSshScript setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GenerateSshScript) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GenerateSshScript setQuotaUser(java.lang.String quotaUser) {
            return (GenerateSshScript) super.setQuotaUser(quotaUser);
          }

          @Override
          public GenerateSshScript setUploadType(java.lang.String uploadType) {
            return (GenerateSshScript) super.setUploadType(uploadType);
          }

          @Override
          public GenerateSshScript setUploadProtocol(java.lang.String uploadProtocol) {
            return (GenerateSshScript) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to generate the SSH script. */
          @com.google.api.client.util.Key
          private java.lang.String migrationJob;

          /** Name of the migration job resource to generate the SSH script.
           */
          public java.lang.String getMigrationJob() {
            return migrationJob;
          }

          /** Name of the migration job resource to generate the SSH script. */
          public GenerateSshScript setMigrationJob(java.lang.String migrationJob) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(MIGRATION_JOB_PATTERN.matcher(migrationJob).matches(),
                  "Parameter migrationJob must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.migrationJob = migrationJob;
            return this;
          }

          @Override
          public GenerateSshScript set(String parameterName, Object value) {
            return (GenerateSshScript) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of a single migration job.
         *
         * Create a request for the method "migrationJobs.get".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Name of the migration job resource to get.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.MigrationJob> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Gets details of a single migration job.
           *
           * Create a request for the method "migrationJobs.get".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Name of the migration job resource to get.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.MigrationJob.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Name of the migration job resource to get. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Name of the migration job resource to get.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. Name of the migration job resource to get. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "migrationJobs.getIamPolicy".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "migrationJobs.getIamPolicy".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The policy format version to be returned. Valid values are 0, 1, and 3. Requests
         specifying an invalid value will be rejected. Requests for policies with any conditional bindings
         must specify version 3. Policies without any conditional bindings may specify any valid value or
         leave the field unset. To learn which resources support conditions in their IAM policies, see the
         [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The policy format version to be returned. Valid values are 0, 1, and 3.
           * Requests specifying an invalid value will be rejected. Requests for policies with any
           * conditional bindings must specify version 3. Policies without any conditional bindings
           * may specify any valid value or leave the field unset. To learn which resources support
           * conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Lists migration jobs in a given project and location.
         *
         * Create a request for the method "migrationJobs.list".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The parent, which owns this collection of migrationJobs.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.ListMigrationJobsResponse> {

          private static final String REST_PATH = "v1/{+parent}/migrationJobs";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists migration jobs in a given project and location.
           *
           * Create a request for the method "migrationJobs.list".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The parent, which owns this collection of migrationJobs.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.ListMigrationJobsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The parent, which owns this collection of migrationJobs. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The parent, which owns this collection of migrationJobs.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. The parent, which owns this collection of migrationJobs. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * A filter expression that filters migration jobs listed in the response. The expression
           * must specify the field name, a comparison operator, and the value that you want to use
           * for filtering. The value must be a string, a number, or a boolean. The comparison
           * operator must be either =, !=, >, or <. For example, list migration jobs created this
           * year by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can also
           * filter nested fields. For example, you could specify **reverseSshConnectivity.vmIp =
           * "1.2.3.4"** to select all migration jobs connecting through the specific SSH tunnel
           * bastion.
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** A filter expression that filters migration jobs listed in the response. The expression must specify
         the field name, a comparison operator, and the value that you want to use for filtering. The value
         must be a string, a number, or a boolean. The comparison operator must be either =, !=, >, or <.
         For example, list migration jobs created this year by specifying **createTime %gt;
         2020-01-01T00:00:00.000000000Z.** You can also filter nested fields. For example, you could specify
         **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration jobs connecting through the
         specific SSH tunnel bastion.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * A filter expression that filters migration jobs listed in the response. The expression
           * must specify the field name, a comparison operator, and the value that you want to use
           * for filtering. The value must be a string, a number, or a boolean. The comparison
           * operator must be either =, !=, >, or <. For example, list migration jobs created this
           * year by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.** You can also
           * filter nested fields. For example, you could specify **reverseSshConnectivity.vmIp =
           * "1.2.3.4"** to select all migration jobs connecting through the specific SSH tunnel
           * bastion.
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * Sort the results based on the migration job name. Valid values are: "name", "name asc",
           * and "name desc".
           */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Sort the results based on the migration job name. Valid values are: "name", "name asc", and "name
         desc".
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /**
           * Sort the results based on the migration job name. Valid values are: "name", "name asc",
           * and "name desc".
           */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /**
           * The maximum number of migration jobs to return. The service may return fewer than this
           * value. If unspecified, at most 50 migration jobs will be returned. The maximum value is
           * 1000; values above 1000 will be coerced to 1000.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The maximum number of migration jobs to return. The service may return fewer than this value. If
         unspecified, at most 50 migration jobs will be returned. The maximum value is 1000; values above
         1000 will be coerced to 1000.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * The maximum number of migration jobs to return. The service may return fewer than this
           * value. If unspecified, at most 50 migration jobs will be returned. The maximum value is
           * 1000; values above 1000 will be coerced to 1000.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * The nextPageToken value received in the previous call to migrationJobs.list, used in
           * the subsequent request to retrieve the next page of results. On first call this should
           * be left blank. When paginating, all other parameters provided to migrationJobs.list
           * must match the call that provided the page token.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The nextPageToken value received in the previous call to migrationJobs.list, used in the subsequent
         request to retrieve the next page of results. On first call this should be left blank. When
         paginating, all other parameters provided to migrationJobs.list must match the call that provided
         the page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * The nextPageToken value received in the previous call to migrationJobs.list, used in
           * the subsequent request to retrieve the next page of results. On first call this should
           * be left blank. When paginating, all other parameters provided to migrationJobs.list
           * must match the call that provided the page token.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates the parameters of a single migration job.
         *
         * Create a request for the method "migrationJobs.patch".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The name (URI) of this migration job resource, in the form of:
         *        projects/{project}/locations/{location}/instances/{instance}.
         * @param content the {@link com.google.api.services.datamigration.v1.model.MigrationJob}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.datamigration.v1.model.MigrationJob content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Updates the parameters of a single migration job.
           *
           * Create a request for the method "migrationJobs.patch".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name (URI) of this migration job resource, in the form of:
         *        projects/{project}/locations/{location}/instances/{instance}.
           * @param content the {@link com.google.api.services.datamigration.v1.model.MigrationJob}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.datamigration.v1.model.MigrationJob content) {
            super(DatabaseMigrationService.this, "PATCH", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The name (URI) of this migration job resource, in the form of:
           * projects/{project}/locations/{location}/instances/{instance}.
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name (URI) of this migration job resource, in the form of:
         projects/{project}/locations/{location}/instances/{instance}.
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The name (URI) of this migration job resource, in the form of:
           * projects/{project}/locations/{location}/instances/{instance}.
           */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          @com.google.api.client.util.Key
          private java.lang.String requestId;

          /** A unique id used to identify the request. If the server receives two requests with the same id,
         then the second request will be ignored. It is recommended to always set this value to a UUID. The
         id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). The
         maximum length is 40 characters.
           */
          public java.lang.String getRequestId() {
            return requestId;
          }

          /**
           * A unique id used to identify the request. If the server receives two requests with the
           * same id, then the second request will be ignored. It is recommended to always set this
           * value to a UUID. The id must contain only letters (a-z, A-Z), numbers (0-9),
           * underscores (_), and hyphens (-). The maximum length is 40 characters.
           */
          public Patch setRequestId(java.lang.String requestId) {
            this.requestId = requestId;
            return this;
          }

          /**
           * Required. Field mask is used to specify the fields to be overwritten in the migration
           * job resource by the update.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** Required. Field mask is used to specify the fields to be overwritten in the migration job resource
         by the update.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * Required. Field mask is used to specify the fields to be overwritten in the migration
           * job resource by the update.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Promote a migration job, stopping replication to the destination and promoting the destination to
         * be a standalone database.
         *
         * Create a request for the method "migrationJobs.promote".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Promote#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to promote.
         * @param content the {@link com.google.api.services.datamigration.v1.model.PromoteMigrationJobRequest}
         * @return the request
         */
        public Promote promote(java.lang.String name, com.google.api.services.datamigration.v1.model.PromoteMigrationJobRequest content) throws java.io.IOException {
          Promote result = new Promote(name, content);
          initialize(result);
          return result;
        }

        public class Promote extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:promote";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Promote a migration job, stopping replication to the destination and promoting the destination
           * to be a standalone database.
           *
           * Create a request for the method "migrationJobs.promote".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Promote#execute()} method to invoke the remote operation.
           * <p> {@link
           * Promote#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to promote.
           * @param content the {@link com.google.api.services.datamigration.v1.model.PromoteMigrationJobRequest}
           * @since 1.13
           */
          protected Promote(java.lang.String name, com.google.api.services.datamigration.v1.model.PromoteMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Promote set$Xgafv(java.lang.String $Xgafv) {
            return (Promote) super.set$Xgafv($Xgafv);
          }

          @Override
          public Promote setAccessToken(java.lang.String accessToken) {
            return (Promote) super.setAccessToken(accessToken);
          }

          @Override
          public Promote setAlt(java.lang.String alt) {
            return (Promote) super.setAlt(alt);
          }

          @Override
          public Promote setCallback(java.lang.String callback) {
            return (Promote) super.setCallback(callback);
          }

          @Override
          public Promote setFields(java.lang.String fields) {
            return (Promote) super.setFields(fields);
          }

          @Override
          public Promote setKey(java.lang.String key) {
            return (Promote) super.setKey(key);
          }

          @Override
          public Promote setOauthToken(java.lang.String oauthToken) {
            return (Promote) super.setOauthToken(oauthToken);
          }

          @Override
          public Promote setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Promote) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Promote setQuotaUser(java.lang.String quotaUser) {
            return (Promote) super.setQuotaUser(quotaUser);
          }

          @Override
          public Promote setUploadType(java.lang.String uploadType) {
            return (Promote) super.setUploadType(uploadType);
          }

          @Override
          public Promote setUploadProtocol(java.lang.String uploadProtocol) {
            return (Promote) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to promote. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to promote.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to promote. */
          public Promote setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Promote set(String parameterName, Object value) {
            return (Promote) super.set(parameterName, value);
          }
        }
        /**
         * Restart a stopped or failed migration job, resetting the destination instance to its original
         * state and starting the migration process from scratch.
         *
         * Create a request for the method "migrationJobs.restart".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Restart#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to restart.
         * @param content the {@link com.google.api.services.datamigration.v1.model.RestartMigrationJobRequest}
         * @return the request
         */
        public Restart restart(java.lang.String name, com.google.api.services.datamigration.v1.model.RestartMigrationJobRequest content) throws java.io.IOException {
          Restart result = new Restart(name, content);
          initialize(result);
          return result;
        }

        public class Restart extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:restart";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Restart a stopped or failed migration job, resetting the destination instance to its original
           * state and starting the migration process from scratch.
           *
           * Create a request for the method "migrationJobs.restart".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Restart#execute()} method to invoke the remote operation.
           * <p> {@link
           * Restart#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to restart.
           * @param content the {@link com.google.api.services.datamigration.v1.model.RestartMigrationJobRequest}
           * @since 1.13
           */
          protected Restart(java.lang.String name, com.google.api.services.datamigration.v1.model.RestartMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Restart set$Xgafv(java.lang.String $Xgafv) {
            return (Restart) super.set$Xgafv($Xgafv);
          }

          @Override
          public Restart setAccessToken(java.lang.String accessToken) {
            return (Restart) super.setAccessToken(accessToken);
          }

          @Override
          public Restart setAlt(java.lang.String alt) {
            return (Restart) super.setAlt(alt);
          }

          @Override
          public Restart setCallback(java.lang.String callback) {
            return (Restart) super.setCallback(callback);
          }

          @Override
          public Restart setFields(java.lang.String fields) {
            return (Restart) super.setFields(fields);
          }

          @Override
          public Restart setKey(java.lang.String key) {
            return (Restart) super.setKey(key);
          }

          @Override
          public Restart setOauthToken(java.lang.String oauthToken) {
            return (Restart) super.setOauthToken(oauthToken);
          }

          @Override
          public Restart setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Restart) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Restart setQuotaUser(java.lang.String quotaUser) {
            return (Restart) super.setQuotaUser(quotaUser);
          }

          @Override
          public Restart setUploadType(java.lang.String uploadType) {
            return (Restart) super.setUploadType(uploadType);
          }

          @Override
          public Restart setUploadProtocol(java.lang.String uploadProtocol) {
            return (Restart) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to restart. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to restart.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to restart. */
          public Restart setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Restart set(String parameterName, Object value) {
            return (Restart) super.set(parameterName, value);
          }
        }
        /**
         * Resume a migration job that is currently stopped and is resumable (was stopped during CDC phase).
         *
         * Create a request for the method "migrationJobs.resume".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Resume#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to resume.
         * @param content the {@link com.google.api.services.datamigration.v1.model.ResumeMigrationJobRequest}
         * @return the request
         */
        public Resume resume(java.lang.String name, com.google.api.services.datamigration.v1.model.ResumeMigrationJobRequest content) throws java.io.IOException {
          Resume result = new Resume(name, content);
          initialize(result);
          return result;
        }

        public class Resume extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:resume";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Resume a migration job that is currently stopped and is resumable (was stopped during CDC
           * phase).
           *
           * Create a request for the method "migrationJobs.resume".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Resume#execute()} method to invoke the remote operation.
           * <p> {@link
           * Resume#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to resume.
           * @param content the {@link com.google.api.services.datamigration.v1.model.ResumeMigrationJobRequest}
           * @since 1.13
           */
          protected Resume(java.lang.String name, com.google.api.services.datamigration.v1.model.ResumeMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Resume set$Xgafv(java.lang.String $Xgafv) {
            return (Resume) super.set$Xgafv($Xgafv);
          }

          @Override
          public Resume setAccessToken(java.lang.String accessToken) {
            return (Resume) super.setAccessToken(accessToken);
          }

          @Override
          public Resume setAlt(java.lang.String alt) {
            return (Resume) super.setAlt(alt);
          }

          @Override
          public Resume setCallback(java.lang.String callback) {
            return (Resume) super.setCallback(callback);
          }

          @Override
          public Resume setFields(java.lang.String fields) {
            return (Resume) super.setFields(fields);
          }

          @Override
          public Resume setKey(java.lang.String key) {
            return (Resume) super.setKey(key);
          }

          @Override
          public Resume setOauthToken(java.lang.String oauthToken) {
            return (Resume) super.setOauthToken(oauthToken);
          }

          @Override
          public Resume setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Resume) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Resume setQuotaUser(java.lang.String quotaUser) {
            return (Resume) super.setQuotaUser(quotaUser);
          }

          @Override
          public Resume setUploadType(java.lang.String uploadType) {
            return (Resume) super.setUploadType(uploadType);
          }

          @Override
          public Resume setUploadProtocol(java.lang.String uploadProtocol) {
            return (Resume) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to resume. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to resume.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to resume. */
          public Resume setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Resume set(String parameterName, Object value) {
            return (Resume) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "migrationJobs.setIamPolicy".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.datamigration.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.datamigration.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "migrationJobs.setIamPolicy".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.datamigration.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.datamigration.v1.model.SetIamPolicyRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Start an already created migration job.
         *
         * Create a request for the method "migrationJobs.start".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Start#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to start.
         * @param content the {@link com.google.api.services.datamigration.v1.model.StartMigrationJobRequest}
         * @return the request
         */
        public Start start(java.lang.String name, com.google.api.services.datamigration.v1.model.StartMigrationJobRequest content) throws java.io.IOException {
          Start result = new Start(name, content);
          initialize(result);
          return result;
        }

        public class Start extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:start";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Start an already created migration job.
           *
           * Create a request for the method "migrationJobs.start".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Start#execute()} method to invoke the remote operation.
           * <p> {@link
           * Start#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to start.
           * @param content the {@link com.google.api.services.datamigration.v1.model.StartMigrationJobRequest}
           * @since 1.13
           */
          protected Start(java.lang.String name, com.google.api.services.datamigration.v1.model.StartMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Start set$Xgafv(java.lang.String $Xgafv) {
            return (Start) super.set$Xgafv($Xgafv);
          }

          @Override
          public Start setAccessToken(java.lang.String accessToken) {
            return (Start) super.setAccessToken(accessToken);
          }

          @Override
          public Start setAlt(java.lang.String alt) {
            return (Start) super.setAlt(alt);
          }

          @Override
          public Start setCallback(java.lang.String callback) {
            return (Start) super.setCallback(callback);
          }

          @Override
          public Start setFields(java.lang.String fields) {
            return (Start) super.setFields(fields);
          }

          @Override
          public Start setKey(java.lang.String key) {
            return (Start) super.setKey(key);
          }

          @Override
          public Start setOauthToken(java.lang.String oauthToken) {
            return (Start) super.setOauthToken(oauthToken);
          }

          @Override
          public Start setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Start) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Start setQuotaUser(java.lang.String quotaUser) {
            return (Start) super.setQuotaUser(quotaUser);
          }

          @Override
          public Start setUploadType(java.lang.String uploadType) {
            return (Start) super.setUploadType(uploadType);
          }

          @Override
          public Start setUploadProtocol(java.lang.String uploadProtocol) {
            return (Start) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to start. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to start.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to start. */
          public Start setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Start set(String parameterName, Object value) {
            return (Start) super.set(parameterName, value);
          }
        }
        /**
         * Stops a running migration job.
         *
         * Create a request for the method "migrationJobs.stop".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to stop.
         * @param content the {@link com.google.api.services.datamigration.v1.model.StopMigrationJobRequest}
         * @return the request
         */
        public Stop stop(java.lang.String name, com.google.api.services.datamigration.v1.model.StopMigrationJobRequest content) throws java.io.IOException {
          Stop result = new Stop(name, content);
          initialize(result);
          return result;
        }

        public class Stop extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:stop";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Stops a running migration job.
           *
           * Create a request for the method "migrationJobs.stop".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p>
           * {@link Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to stop.
           * @param content the {@link com.google.api.services.datamigration.v1.model.StopMigrationJobRequest}
           * @since 1.13
           */
          protected Stop(java.lang.String name, com.google.api.services.datamigration.v1.model.StopMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Stop set$Xgafv(java.lang.String $Xgafv) {
            return (Stop) super.set$Xgafv($Xgafv);
          }

          @Override
          public Stop setAccessToken(java.lang.String accessToken) {
            return (Stop) super.setAccessToken(accessToken);
          }

          @Override
          public Stop setAlt(java.lang.String alt) {
            return (Stop) super.setAlt(alt);
          }

          @Override
          public Stop setCallback(java.lang.String callback) {
            return (Stop) super.setCallback(callback);
          }

          @Override
          public Stop setFields(java.lang.String fields) {
            return (Stop) super.setFields(fields);
          }

          @Override
          public Stop setKey(java.lang.String key) {
            return (Stop) super.setKey(key);
          }

          @Override
          public Stop setOauthToken(java.lang.String oauthToken) {
            return (Stop) super.setOauthToken(oauthToken);
          }

          @Override
          public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Stop) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Stop setQuotaUser(java.lang.String quotaUser) {
            return (Stop) super.setQuotaUser(quotaUser);
          }

          @Override
          public Stop setUploadType(java.lang.String uploadType) {
            return (Stop) super.setUploadType(uploadType);
          }

          @Override
          public Stop setUploadProtocol(java.lang.String uploadProtocol) {
            return (Stop) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to stop. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to stop.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to stop. */
          public Stop setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Stop set(String parameterName, Object value) {
            return (Stop) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
         * designed to be used for building permission-aware UIs and command-line tools, not for
         * authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "migrationJobs.testIamPermissions".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
           * operation is designed to be used for building permission-aware UIs and command-line tools, not
           * for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "migrationJobs.testIamPermissions".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.datamigration.v1.model.TestIamPermissionsRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }
        /**
         * Verify a migration job, making sure the destination can reach the source and that all
         * configuration and prerequisites are met.
         *
         * Create a request for the method "migrationJobs.verify".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Verify#execute()} method to invoke the remote operation.
         *
         * @param name Name of the migration job resource to verify.
         * @param content the {@link com.google.api.services.datamigration.v1.model.VerifyMigrationJobRequest}
         * @return the request
         */
        public Verify verify(java.lang.String name, com.google.api.services.datamigration.v1.model.VerifyMigrationJobRequest content) throws java.io.IOException {
          Verify result = new Verify(name, content);
          initialize(result);
          return result;
        }

        public class Verify extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:verify";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");

          /**
           * Verify a migration job, making sure the destination can reach the source and that all
           * configuration and prerequisites are met.
           *
           * Create a request for the method "migrationJobs.verify".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Verify#execute()} method to invoke the remote operation.
           * <p> {@link
           * Verify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Name of the migration job resource to verify.
           * @param content the {@link com.google.api.services.datamigration.v1.model.VerifyMigrationJobRequest}
           * @since 1.13
           */
          protected Verify(java.lang.String name, com.google.api.services.datamigration.v1.model.VerifyMigrationJobRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
          }

          @Override
          public Verify set$Xgafv(java.lang.String $Xgafv) {
            return (Verify) super.set$Xgafv($Xgafv);
          }

          @Override
          public Verify setAccessToken(java.lang.String accessToken) {
            return (Verify) super.setAccessToken(accessToken);
          }

          @Override
          public Verify setAlt(java.lang.String alt) {
            return (Verify) super.setAlt(alt);
          }

          @Override
          public Verify setCallback(java.lang.String callback) {
            return (Verify) super.setCallback(callback);
          }

          @Override
          public Verify setFields(java.lang.String fields) {
            return (Verify) super.setFields(fields);
          }

          @Override
          public Verify setKey(java.lang.String key) {
            return (Verify) super.setKey(key);
          }

          @Override
          public Verify setOauthToken(java.lang.String oauthToken) {
            return (Verify) super.setOauthToken(oauthToken);
          }

          @Override
          public Verify setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Verify) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Verify setQuotaUser(java.lang.String quotaUser) {
            return (Verify) super.setQuotaUser(quotaUser);
          }

          @Override
          public Verify setUploadType(java.lang.String uploadType) {
            return (Verify) super.setUploadType(uploadType);
          }

          @Override
          public Verify setUploadProtocol(java.lang.String uploadProtocol) {
            return (Verify) super.setUploadProtocol(uploadProtocol);
          }

          /** Name of the migration job resource to verify. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Name of the migration job resource to verify.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Name of the migration job resource to verify. */
          public Verify setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/migrationJobs/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Verify set(String parameterName, Object value) {
            return (Verify) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code DatabaseMigrationService datamigration = new DatabaseMigrationService(...);}
       *   {@code DatabaseMigrationService.Operations.List request = datamigration.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
         * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
         * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
         * methods to check whether the cancellation succeeded or whether the operation completed despite
         * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
         * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
         * `Code.CANCELLED`.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be cancelled.
         * @param content the {@link com.google.api.services.datamigration.v1.model.CancelOperationRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String name, com.google.api.services.datamigration.v1.model.CancelOperationRequest content) throws java.io.IOException {
          Cancel result = new Cancel(name, content);
          initialize(result);
          return result;
        }

        public class Cancel extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:cancel";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
           * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
           * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
           * methods to check whether the cancellation succeeded or whether the operation completed despite
           * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
           * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
           * `Code.CANCELLED`.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be cancelled.
           * @param content the {@link com.google.api.services.datamigration.v1.model.CancelOperationRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String name, com.google.api.services.datamigration.v1.model.CancelOperationRequest content) {
            super(DatabaseMigrationService.this, "POST", REST_PATH, content, com.google.api.services.datamigration.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be cancelled. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be cancelled.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be cancelled. */
          public Cancel setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a long-running operation. This method indicates that the client is no longer interested
         * in the operation result. It does not cancel the operation. If the server doesn't support this
         * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
         *
         * Create a request for the method "operations.delete".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Deletes a long-running operation. This method indicates that the client is no longer interested
           * in the operation result. It does not cancel the operation. If the server doesn't support this
           * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
           *
           * Create a request for the method "operations.delete".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(DatabaseMigrationService.this, "DELETE", REST_PATH, null, com.google.api.services.datamigration.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be deleted.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be deleted. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Gets the latest state of a long-running operation. Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support
         * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override
         * the binding to use different resource name schemes, such as `users/operations`. To override the
         * binding, API services can add a binding such as `"/v1/{name=users}/operations"` to their service
         * configuration. For backwards compatibility, the default name includes the operations collection
         * id, however overriding users must ensure the name binding is the parent resource, without the
         * operations collection id.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the datamigration server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation's parent resource.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends DatabaseMigrationServiceRequest<com.google.api.services.datamigration.v1.model.ListOperationsResponse> {

          private static final String REST_PATH = "v1/{+name}/operations";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists operations that match the specified filter in the request. If the server doesn't support
           * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
           * override the binding to use different resource name schemes, such as `users/operations`. To
           * override the binding, API services can add a binding such as `"/v1/{name=users}/operations"` to
           * their service configuration. For backwards compatibility, the default name includes the
           * operations collection id, however overriding users must ensure the name binding is the parent
           * resource, without the operations collection id.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the datamigration server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation's parent resource.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(DatabaseMigrationService.this, "GET", REST_PATH, null, com.google.api.services.datamigration.v1.model.ListOperationsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation's parent resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation's parent resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation's parent resource. */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /** The standard list filter. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** The standard list filter.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** The standard list filter. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** The standard list page size. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The standard list page size.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The standard list page size. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /** The standard list page token. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The standard list page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The standard list page token. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link DatabaseMigrationService}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link DatabaseMigrationService}. */
    @Override
    public DatabaseMigrationService build() {
      return new DatabaseMigrationService(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DatabaseMigrationServiceRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDatabaseMigrationServiceRequestInitializer(
        DatabaseMigrationServiceRequestInitializer databasemigrationserviceRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(databasemigrationserviceRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
