/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1.model;

/**
 * Error message of a verification Migration job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MigrationJobVerificationError extends com.google.api.client.json.GenericJson {

  /**
   * Output only. An instance of ErrorCode specifying the error that occurred.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorCode;

  /**
   * Output only. A specific detailed error message, if supplied by the engine.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorDetailMessage;

  /**
   * Output only. A formatted message with further details about the error and a CTA.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String errorMessage;

  /**
   * Output only. An instance of ErrorCode specifying the error that occurred.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorCode() {
    return errorCode;
  }

  /**
   * Output only. An instance of ErrorCode specifying the error that occurred.
   * @param errorCode errorCode or {@code null} for none
   */
  public MigrationJobVerificationError setErrorCode(java.lang.String errorCode) {
    this.errorCode = errorCode;
    return this;
  }

  /**
   * Output only. A specific detailed error message, if supplied by the engine.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorDetailMessage() {
    return errorDetailMessage;
  }

  /**
   * Output only. A specific detailed error message, if supplied by the engine.
   * @param errorDetailMessage errorDetailMessage or {@code null} for none
   */
  public MigrationJobVerificationError setErrorDetailMessage(java.lang.String errorDetailMessage) {
    this.errorDetailMessage = errorDetailMessage;
    return this;
  }

  /**
   * Output only. A formatted message with further details about the error and a CTA.
   * @return value or {@code null} for none
   */
  public java.lang.String getErrorMessage() {
    return errorMessage;
  }

  /**
   * Output only. A formatted message with further details about the error and a CTA.
   * @param errorMessage errorMessage or {@code null} for none
   */
  public MigrationJobVerificationError setErrorMessage(java.lang.String errorMessage) {
    this.errorMessage = errorMessage;
    return this;
  }

  @Override
  public MigrationJobVerificationError set(String fieldName, Object value) {
    return (MigrationJobVerificationError) super.set(fieldName, value);
  }

  @Override
  public MigrationJobVerificationError clone() {
    return (MigrationJobVerificationError) super.clone();
  }

}
