/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1.model;

/**
 * A connection profile definition.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConnectionProfile extends com.google.api.client.json.GenericJson {

  /**
   * A CloudSQL database connection profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CloudSqlConnectionProfile cloudsql;

  /**
   * Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC "Zulu"
   * format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The connection profile display name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. The error details in case of state FAILED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Status error;

  /**
   * The resource labels for connection profile to use to annotate any related underlying resources
   * such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{
   * "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * A MySQL database connection profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MySqlConnectionProfile mysql;

  /**
   * The name of this connection profile resource in the form of
   * projects/{project}/locations/{location}/connectionProfiles/{instance}.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A PostgreSQL database connection profile.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PostgreSqlConnectionProfile postgresql;

  /**
   * The database provider.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String provider;

  /**
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. The timestamp when the resource was last updated. A timestamp in RFC3339 UTC
   * "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * A CloudSQL database connection profile.
   * @return value or {@code null} for none
   */
  public CloudSqlConnectionProfile getCloudsql() {
    return cloudsql;
  }

  /**
   * A CloudSQL database connection profile.
   * @param cloudsql cloudsql or {@code null} for none
   */
  public ConnectionProfile setCloudsql(CloudSqlConnectionProfile cloudsql) {
    this.cloudsql = cloudsql;
    return this;
  }

  /**
   * Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC "Zulu"
   * format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC "Zulu"
   * format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * @param createTime createTime or {@code null} for none
   */
  public ConnectionProfile setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The connection profile display name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The connection profile display name.
   * @param displayName displayName or {@code null} for none
   */
  public ConnectionProfile setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. The error details in case of state FAILED.
   * @return value or {@code null} for none
   */
  public Status getError() {
    return error;
  }

  /**
   * Output only. The error details in case of state FAILED.
   * @param error error or {@code null} for none
   */
  public ConnectionProfile setError(Status error) {
    this.error = error;
    return this;
  }

  /**
   * The resource labels for connection profile to use to annotate any related underlying resources
   * such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{
   * "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * The resource labels for connection profile to use to annotate any related underlying resources
   * such as Compute Engine VMs. An object containing a list of "key": "value" pairs. Example: `{
   * "name": "wrench", "mass": "1.3kg", "count": "3" }`.
   * @param labels labels or {@code null} for none
   */
  public ConnectionProfile setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * A MySQL database connection profile.
   * @return value or {@code null} for none
   */
  public MySqlConnectionProfile getMysql() {
    return mysql;
  }

  /**
   * A MySQL database connection profile.
   * @param mysql mysql or {@code null} for none
   */
  public ConnectionProfile setMysql(MySqlConnectionProfile mysql) {
    this.mysql = mysql;
    return this;
  }

  /**
   * The name of this connection profile resource in the form of
   * projects/{project}/locations/{location}/connectionProfiles/{instance}.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this connection profile resource in the form of
   * projects/{project}/locations/{location}/connectionProfiles/{instance}.
   * @param name name or {@code null} for none
   */
  public ConnectionProfile setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A PostgreSQL database connection profile.
   * @return value or {@code null} for none
   */
  public PostgreSqlConnectionProfile getPostgresql() {
    return postgresql;
  }

  /**
   * A PostgreSQL database connection profile.
   * @param postgresql postgresql or {@code null} for none
   */
  public ConnectionProfile setPostgresql(PostgreSqlConnectionProfile postgresql) {
    this.postgresql = postgresql;
    return this;
  }

  /**
   * The database provider.
   * @return value or {@code null} for none
   */
  public java.lang.String getProvider() {
    return provider;
  }

  /**
   * The database provider.
   * @param provider provider or {@code null} for none
   */
  public ConnectionProfile setProvider(java.lang.String provider) {
    this.provider = provider;
    return this;
  }

  /**
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The current connection profile state (e.g. DRAFT, READY, or FAILED).
   * @param state state or {@code null} for none
   */
  public ConnectionProfile setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. The timestamp when the resource was last updated. A timestamp in RFC3339 UTC
   * "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. The timestamp when the resource was last updated. A timestamp in RFC3339 UTC
   * "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
   * @param updateTime updateTime or {@code null} for none
   */
  public ConnectionProfile setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public ConnectionProfile set(String fieldName, Object value) {
    return (ConnectionProfile) super.set(fieldName, value);
  }

  @Override
  public ConnectionProfile clone() {
    return (ConnectionProfile) super.clone();
  }

}
