/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1.model;

/**
 * The details needed to configure a reverse SSH tunnel between the source and destination
 * databases. These details will be used when calling the generateSshScript method (see
 * https://cloud.google.com/database-
 * migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript) to produce
 * the script that will help set up the reverse SSH tunnel, and to set up the VPC peering between
 * the Cloud SQL private network and the VPC.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReverseSshConnectivity extends com.google.api.client.json.GenericJson {

  /**
   * The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vm;

  /**
   * Required. The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH
   * tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmIp;

  /**
   * Required. The forwarding port of the virtual machine (Compute Engine) used as the bastion
   * server for the SSH tunnel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer vmPort;

  /**
   * The name of the VPC to peer with the Cloud SQL private network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vpc;

  /**
   * The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.String getVm() {
    return vm;
  }

  /**
   * The name of the virtual machine (Compute Engine) used as the bastion server for the SSH tunnel.
   * @param vm vm or {@code null} for none
   */
  public ReverseSshConnectivity setVm(java.lang.String vm) {
    this.vm = vm;
    return this;
  }

  /**
   * Required. The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH
   * tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmIp() {
    return vmIp;
  }

  /**
   * Required. The IP of the virtual machine (Compute Engine) used as the bastion server for the SSH
   * tunnel.
   * @param vmIp vmIp or {@code null} for none
   */
  public ReverseSshConnectivity setVmIp(java.lang.String vmIp) {
    this.vmIp = vmIp;
    return this;
  }

  /**
   * Required. The forwarding port of the virtual machine (Compute Engine) used as the bastion
   * server for the SSH tunnel.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getVmPort() {
    return vmPort;
  }

  /**
   * Required. The forwarding port of the virtual machine (Compute Engine) used as the bastion
   * server for the SSH tunnel.
   * @param vmPort vmPort or {@code null} for none
   */
  public ReverseSshConnectivity setVmPort(java.lang.Integer vmPort) {
    this.vmPort = vmPort;
    return this;
  }

  /**
   * The name of the VPC to peer with the Cloud SQL private network.
   * @return value or {@code null} for none
   */
  public java.lang.String getVpc() {
    return vpc;
  }

  /**
   * The name of the VPC to peer with the Cloud SQL private network.
   * @param vpc vpc or {@code null} for none
   */
  public ReverseSshConnectivity setVpc(java.lang.String vpc) {
    this.vpc = vpc;
    return this;
  }

  @Override
  public ReverseSshConnectivity set(String fieldName, Object value) {
    return (ReverseSshConnectivity) super.set(fieldName, value);
  }

  @Override
  public ReverseSshConnectivity clone() {
    return (ReverseSshConnectivity) super.clone();
  }

}
