/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.datamigration.v1.model;

/**
 * VM creation configuration message
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Database Migration API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VmCreationConfig extends com.google.api.client.json.GenericJson {

  /**
   * The subnet name the vm needs to be created in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnet;

  /**
   * Required. VM instance machine type to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmMachineType;

  /**
   * The Google Cloud Platform zone to create the VM in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmZone;

  /**
   * The subnet name the vm needs to be created in.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnet() {
    return subnet;
  }

  /**
   * The subnet name the vm needs to be created in.
   * @param subnet subnet or {@code null} for none
   */
  public VmCreationConfig setSubnet(java.lang.String subnet) {
    this.subnet = subnet;
    return this;
  }

  /**
   * Required. VM instance machine type to create.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmMachineType() {
    return vmMachineType;
  }

  /**
   * Required. VM instance machine type to create.
   * @param vmMachineType vmMachineType or {@code null} for none
   */
  public VmCreationConfig setVmMachineType(java.lang.String vmMachineType) {
    this.vmMachineType = vmMachineType;
    return this;
  }

  /**
   * The Google Cloud Platform zone to create the VM in.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmZone() {
    return vmZone;
  }

  /**
   * The Google Cloud Platform zone to create the VM in.
   * @param vmZone vmZone or {@code null} for none
   */
  public VmCreationConfig setVmZone(java.lang.String vmZone) {
    this.vmZone = vmZone;
    return this;
  }

  @Override
  public VmCreationConfig set(String fieldName, Object value) {
    return (VmCreationConfig) super.set(fieldName, value);
  }

  @Override
  public VmCreationConfig clone() {
    return (VmCreationConfig) super.clone();
  }

}
