/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A structuredstacktrace for a process running on the worker.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Stack extends com.google.api.client.json.GenericJson {

  /**
   * The raw stack trace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stackContent;

  /**
   * With java thread dumps we may get collapsed stacks e.g., N threads in stack "". Instead of
   * having to copy over the same stack trace N times, this int field captures this.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer threadCount;

  /**
   * Thread name. For example, "CommitThread-0,10,main"
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String threadName;

  /**
   * The state of the thread. For example, "WAITING".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String threadState;

  /**
   * Timestamp at which the stack was captured.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timestamp;

  /**
   * The raw stack trace.
   * @return value or {@code null} for none
   */
  public java.lang.String getStackContent() {
    return stackContent;
  }

  /**
   * The raw stack trace.
   * @param stackContent stackContent or {@code null} for none
   */
  public Stack setStackContent(java.lang.String stackContent) {
    this.stackContent = stackContent;
    return this;
  }

  /**
   * With java thread dumps we may get collapsed stacks e.g., N threads in stack "". Instead of
   * having to copy over the same stack trace N times, this int field captures this.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getThreadCount() {
    return threadCount;
  }

  /**
   * With java thread dumps we may get collapsed stacks e.g., N threads in stack "". Instead of
   * having to copy over the same stack trace N times, this int field captures this.
   * @param threadCount threadCount or {@code null} for none
   */
  public Stack setThreadCount(java.lang.Integer threadCount) {
    this.threadCount = threadCount;
    return this;
  }

  /**
   * Thread name. For example, "CommitThread-0,10,main"
   * @return value or {@code null} for none
   */
  public java.lang.String getThreadName() {
    return threadName;
  }

  /**
   * Thread name. For example, "CommitThread-0,10,main"
   * @param threadName threadName or {@code null} for none
   */
  public Stack setThreadName(java.lang.String threadName) {
    this.threadName = threadName;
    return this;
  }

  /**
   * The state of the thread. For example, "WAITING".
   * @return value or {@code null} for none
   */
  public java.lang.String getThreadState() {
    return threadState;
  }

  /**
   * The state of the thread. For example, "WAITING".
   * @param threadState threadState or {@code null} for none
   */
  public Stack setThreadState(java.lang.String threadState) {
    this.threadState = threadState;
    return this;
  }

  /**
   * Timestamp at which the stack was captured.
   * @return value or {@code null} for none
   */
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * Timestamp at which the stack was captured.
   * @param timestamp timestamp or {@code null} for none
   */
  public Stack setTimestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  @Override
  public Stack set(String fieldName, Object value) {
    return (Stack) super.set(fieldName, value);
  }

  @Override
  public Stack clone() {
    return (Stack) super.clone();
  }

}
