/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * The version of the SDK used to run the job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SdkVersion extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Known bugs found in this SDK version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SdkBug> bugs;

  static {
    // hack to force ProGuard to consider SdkBug used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SdkBug.class);
  }

  /**
   * The support status for this SDK version.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sdkSupportStatus;

  /**
   * The version of the SDK used to run the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String version;

  /**
   * A readable string describing the version of the SDK.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String versionDisplayName;

  /**
   * Output only. Known bugs found in this SDK version.
   * @return value or {@code null} for none
   */
  public java.util.List<SdkBug> getBugs() {
    return bugs;
  }

  /**
   * Output only. Known bugs found in this SDK version.
   * @param bugs bugs or {@code null} for none
   */
  public SdkVersion setBugs(java.util.List<SdkBug> bugs) {
    this.bugs = bugs;
    return this;
  }

  /**
   * The support status for this SDK version.
   * @return value or {@code null} for none
   */
  public java.lang.String getSdkSupportStatus() {
    return sdkSupportStatus;
  }

  /**
   * The support status for this SDK version.
   * @param sdkSupportStatus sdkSupportStatus or {@code null} for none
   */
  public SdkVersion setSdkSupportStatus(java.lang.String sdkSupportStatus) {
    this.sdkSupportStatus = sdkSupportStatus;
    return this;
  }

  /**
   * The version of the SDK used to run the job.
   * @return value or {@code null} for none
   */
  public java.lang.String getVersion() {
    return version;
  }

  /**
   * The version of the SDK used to run the job.
   * @param version version or {@code null} for none
   */
  public SdkVersion setVersion(java.lang.String version) {
    this.version = version;
    return this;
  }

  /**
   * A readable string describing the version of the SDK.
   * @return value or {@code null} for none
   */
  public java.lang.String getVersionDisplayName() {
    return versionDisplayName;
  }

  /**
   * A readable string describing the version of the SDK.
   * @param versionDisplayName versionDisplayName or {@code null} for none
   */
  public SdkVersion setVersionDisplayName(java.lang.String versionDisplayName) {
    this.versionDisplayName = versionDisplayName;
    return this;
  }

  @Override
  public SdkVersion set(String fieldName, Object value) {
    return (SdkVersion) super.set(fieldName, value);
  }

  @Override
  public SdkVersion clone() {
    return (SdkVersion) super.clone();
  }

}
