/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A bug found in the Dataflow SDK.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SdkBug extends com.google.api.client.json.GenericJson {

  /**
   * Output only. How severe the SDK bug is.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String severity;

  /**
   * Output only. Describes the impact of this SDK bug.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. Link to more information on the bug.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String uri;

  /**
   * Output only. How severe the SDK bug is.
   * @return value or {@code null} for none
   */
  public java.lang.String getSeverity() {
    return severity;
  }

  /**
   * Output only. How severe the SDK bug is.
   * @param severity severity or {@code null} for none
   */
  public SdkBug setSeverity(java.lang.String severity) {
    this.severity = severity;
    return this;
  }

  /**
   * Output only. Describes the impact of this SDK bug.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Describes the impact of this SDK bug.
   * @param type type or {@code null} for none
   */
  public SdkBug setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Output only. Link to more information on the bug.
   * @return value or {@code null} for none
   */
  public java.lang.String getUri() {
    return uri;
  }

  /**
   * Output only. Link to more information on the bug.
   * @param uri uri or {@code null} for none
   */
  public SdkBug setUri(java.lang.String uri) {
    this.uri = uri;
    return this;
  }

  @Override
  public SdkBug set(String fieldName, Object value) {
    return (SdkBug) super.set(fieldName, value);
  }

  @Override
  public SdkBug clone() {
    return (SdkBug) super.clone();
  }

}
