/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * The value of a metric along with its name and labels.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricValue extends com.google.api.client.json.GenericJson {

  /**
   * Base name for this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metric;

  /**
   * Optional. Set of metric labels for this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metricLabels;

  /**
   * Non-cumulative int64 value of this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataflowGaugeValue valueGauge64;

  /**
   * Histogram value of this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataflowHistogramValue valueHistogram;

  /**
   * Integer value of this metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long valueInt64;

  /**
   * Base name for this metric.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetric() {
    return metric;
  }

  /**
   * Base name for this metric.
   * @param metric metric or {@code null} for none
   */
  public MetricValue setMetric(java.lang.String metric) {
    this.metric = metric;
    return this;
  }

  /**
   * Optional. Set of metric labels for this metric.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetricLabels() {
    return metricLabels;
  }

  /**
   * Optional. Set of metric labels for this metric.
   * @param metricLabels metricLabels or {@code null} for none
   */
  public MetricValue setMetricLabels(java.util.Map<String, java.lang.String> metricLabels) {
    this.metricLabels = metricLabels;
    return this;
  }

  /**
   * Non-cumulative int64 value of this metric.
   * @return value or {@code null} for none
   */
  public DataflowGaugeValue getValueGauge64() {
    return valueGauge64;
  }

  /**
   * Non-cumulative int64 value of this metric.
   * @param valueGauge64 valueGauge64 or {@code null} for none
   */
  public MetricValue setValueGauge64(DataflowGaugeValue valueGauge64) {
    this.valueGauge64 = valueGauge64;
    return this;
  }

  /**
   * Histogram value of this metric.
   * @return value or {@code null} for none
   */
  public DataflowHistogramValue getValueHistogram() {
    return valueHistogram;
  }

  /**
   * Histogram value of this metric.
   * @param valueHistogram valueHistogram or {@code null} for none
   */
  public MetricValue setValueHistogram(DataflowHistogramValue valueHistogram) {
    this.valueHistogram = valueHistogram;
    return this;
  }

  /**
   * Integer value of this metric.
   * @return value or {@code null} for none
   */
  public java.lang.Long getValueInt64() {
    return valueInt64;
  }

  /**
   * Integer value of this metric.
   * @param valueInt64 valueInt64 or {@code null} for none
   */
  public MetricValue setValueInt64(java.lang.Long valueInt64) {
    this.valueInt64 = valueInt64;
    return this;
  }

  @Override
  public MetricValue set(String fieldName, Object value) {
    return (MetricValue) super.set(fieldName, value);
  }

  @Override
  public MetricValue clone() {
    return (MetricValue) super.clone();
  }

}
