/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes the state of a metric.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricUpdate extends com.google.api.client.json.GenericJson {

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode. Introduced this field to avoid breaking older SDKs when Dataflow service
   * starts to populate the `bounded_trie` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object boundedTrie;

  /**
   * True if this metric is reported as the total cumulative aggregate value accumulated since the
   * worker started working on this WorkItem. By default this is false, indicating that this metric
   * is reported as a delta that is not associated with any WorkItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean cumulative;

  /**
   * A struct value describing properties of a distribution of numeric values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object distribution;

  /**
   * A struct value describing properties of a Gauge. Metrics of gauge type show the value of a
   * metric across time, and is aggregated based on the newest value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object gauge;

  /**
   * Worker-computed aggregate value for internal use by the Dataflow service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object internal;

  /**
   * Metric aggregation kind. The possible metric aggregation kinds are "Sum", "Max", "Min", "Mean",
   * "Set", "And", "Or", and "Distribution". The specified aggregation kind is case-insensitive. If
   * omitted, this is not an aggregated value but instead a single metric sample value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the count of the
   * aggregated values and is used in combination with mean_sum above to obtain the actual mean
   * aggregate value. The only possible value type is Long.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object meanCount;

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the sum of the
   * aggregated values and is used in combination with mean_count below to obtain the actual mean
   * aggregate value. The only possible value types are Long and Double.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object meanSum;

  /**
   * Name of the metric.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MetricStructuredName name;

  /**
   * Worker-computed aggregate value for aggregation kinds "Sum", "Max", "Min", "And", and "Or". The
   * possible value types are Long, Double, and Boolean.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object scalar;

  /**
   * Worker-computed aggregate value for the "Set" aggregation kind. The only possible value type is
   * a list of Values whose type can be Long, Double, String, or BoundedTrie according to the
   * metric's type. All Values in the list must be of the same type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object set;

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Object trie;

  /**
   * Timestamp associated with the metric value. Optional when workers are reporting work progress;
   * it will be filled in responses from the metrics API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode. Introduced this field to avoid breaking older SDKs when Dataflow service
   * starts to populate the `bounded_trie` field.
   * @return value or {@code null} for none
   */
  public java.lang.Object getBoundedTrie() {
    return boundedTrie;
  }

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode. Introduced this field to avoid breaking older SDKs when Dataflow service
   * starts to populate the `bounded_trie` field.
   * @param boundedTrie boundedTrie or {@code null} for none
   */
  public MetricUpdate setBoundedTrie(java.lang.Object boundedTrie) {
    this.boundedTrie = boundedTrie;
    return this;
  }

  /**
   * True if this metric is reported as the total cumulative aggregate value accumulated since the
   * worker started working on this WorkItem. By default this is false, indicating that this metric
   * is reported as a delta that is not associated with any WorkItem.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCumulative() {
    return cumulative;
  }

  /**
   * True if this metric is reported as the total cumulative aggregate value accumulated since the
   * worker started working on this WorkItem. By default this is false, indicating that this metric
   * is reported as a delta that is not associated with any WorkItem.
   * @param cumulative cumulative or {@code null} for none
   */
  public MetricUpdate setCumulative(java.lang.Boolean cumulative) {
    this.cumulative = cumulative;
    return this;
  }

  /**
   * A struct value describing properties of a distribution of numeric values.
   * @return value or {@code null} for none
   */
  public java.lang.Object getDistribution() {
    return distribution;
  }

  /**
   * A struct value describing properties of a distribution of numeric values.
   * @param distribution distribution or {@code null} for none
   */
  public MetricUpdate setDistribution(java.lang.Object distribution) {
    this.distribution = distribution;
    return this;
  }

  /**
   * A struct value describing properties of a Gauge. Metrics of gauge type show the value of a
   * metric across time, and is aggregated based on the newest value.
   * @return value or {@code null} for none
   */
  public java.lang.Object getGauge() {
    return gauge;
  }

  /**
   * A struct value describing properties of a Gauge. Metrics of gauge type show the value of a
   * metric across time, and is aggregated based on the newest value.
   * @param gauge gauge or {@code null} for none
   */
  public MetricUpdate setGauge(java.lang.Object gauge) {
    this.gauge = gauge;
    return this;
  }

  /**
   * Worker-computed aggregate value for internal use by the Dataflow service.
   * @return value or {@code null} for none
   */
  public java.lang.Object getInternal() {
    return internal;
  }

  /**
   * Worker-computed aggregate value for internal use by the Dataflow service.
   * @param internal internal or {@code null} for none
   */
  public MetricUpdate setInternal(java.lang.Object internal) {
    this.internal = internal;
    return this;
  }

  /**
   * Metric aggregation kind. The possible metric aggregation kinds are "Sum", "Max", "Min", "Mean",
   * "Set", "And", "Or", and "Distribution". The specified aggregation kind is case-insensitive. If
   * omitted, this is not an aggregated value but instead a single metric sample value.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Metric aggregation kind. The possible metric aggregation kinds are "Sum", "Max", "Min", "Mean",
   * "Set", "And", "Or", and "Distribution". The specified aggregation kind is case-insensitive. If
   * omitted, this is not an aggregated value but instead a single metric sample value.
   * @param kind kind or {@code null} for none
   */
  public MetricUpdate setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the count of the
   * aggregated values and is used in combination with mean_sum above to obtain the actual mean
   * aggregate value. The only possible value type is Long.
   * @return value or {@code null} for none
   */
  public java.lang.Object getMeanCount() {
    return meanCount;
  }

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the count of the
   * aggregated values and is used in combination with mean_sum above to obtain the actual mean
   * aggregate value. The only possible value type is Long.
   * @param meanCount meanCount or {@code null} for none
   */
  public MetricUpdate setMeanCount(java.lang.Object meanCount) {
    this.meanCount = meanCount;
    return this;
  }

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the sum of the
   * aggregated values and is used in combination with mean_count below to obtain the actual mean
   * aggregate value. The only possible value types are Long and Double.
   * @return value or {@code null} for none
   */
  public java.lang.Object getMeanSum() {
    return meanSum;
  }

  /**
   * Worker-computed aggregate value for the "Mean" aggregation kind. This holds the sum of the
   * aggregated values and is used in combination with mean_count below to obtain the actual mean
   * aggregate value. The only possible value types are Long and Double.
   * @param meanSum meanSum or {@code null} for none
   */
  public MetricUpdate setMeanSum(java.lang.Object meanSum) {
    this.meanSum = meanSum;
    return this;
  }

  /**
   * Name of the metric.
   * @return value or {@code null} for none
   */
  public MetricStructuredName getName() {
    return name;
  }

  /**
   * Name of the metric.
   * @param name name or {@code null} for none
   */
  public MetricUpdate setName(MetricStructuredName name) {
    this.name = name;
    return this;
  }

  /**
   * Worker-computed aggregate value for aggregation kinds "Sum", "Max", "Min", "And", and "Or". The
   * possible value types are Long, Double, and Boolean.
   * @return value or {@code null} for none
   */
  public java.lang.Object getScalar() {
    return scalar;
  }

  /**
   * Worker-computed aggregate value for aggregation kinds "Sum", "Max", "Min", "And", and "Or". The
   * possible value types are Long, Double, and Boolean.
   * @param scalar scalar or {@code null} for none
   */
  public MetricUpdate setScalar(java.lang.Object scalar) {
    this.scalar = scalar;
    return this;
  }

  /**
   * Worker-computed aggregate value for the "Set" aggregation kind. The only possible value type is
   * a list of Values whose type can be Long, Double, String, or BoundedTrie according to the
   * metric's type. All Values in the list must be of the same type.
   * @return value or {@code null} for none
   */
  public java.lang.Object getSet() {
    return set;
  }

  /**
   * Worker-computed aggregate value for the "Set" aggregation kind. The only possible value type is
   * a list of Values whose type can be Long, Double, String, or BoundedTrie according to the
   * metric's type. All Values in the list must be of the same type.
   * @param set set or {@code null} for none
   */
  public MetricUpdate setSet(java.lang.Object set) {
    this.set = set;
    return this;
  }

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode.
   * @return value or {@code null} for none
   */
  public java.lang.Object getTrie() {
    return trie;
  }

  /**
   * Worker-computed aggregate value for the "Trie" aggregation kind. The only possible value type
   * is a BoundedTrieNode.
   * @param trie trie or {@code null} for none
   */
  public MetricUpdate setTrie(java.lang.Object trie) {
    this.trie = trie;
    return this;
  }

  /**
   * Timestamp associated with the metric value. Optional when workers are reporting work progress;
   * it will be filled in responses from the metrics API.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Timestamp associated with the metric value. Optional when workers are reporting work progress;
   * it will be filled in responses from the metrics API.
   * @param updateTime updateTime or {@code null} for none
   */
  public MetricUpdate setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public MetricUpdate set(String fieldName, Object value) {
    return (MetricUpdate) super.set(fieldName, value);
  }

  @Override
  public MetricUpdate clone() {
    return (MetricUpdate) super.clone();
  }

}
