/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A request to launch a Cloud Dataflow job from a FlexTemplate.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LaunchFlexTemplateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Parameter to launch a job form Flex Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LaunchFlexTemplateParameter launchParameter;

  /**
   * If true, the request is validated but not actually executed. Defaults to false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean validateOnly;

  /**
   * Required. Parameter to launch a job form Flex Template.
   * @return value or {@code null} for none
   */
  public LaunchFlexTemplateParameter getLaunchParameter() {
    return launchParameter;
  }

  /**
   * Required. Parameter to launch a job form Flex Template.
   * @param launchParameter launchParameter or {@code null} for none
   */
  public LaunchFlexTemplateRequest setLaunchParameter(LaunchFlexTemplateParameter launchParameter) {
    this.launchParameter = launchParameter;
    return this;
  }

  /**
   * If true, the request is validated but not actually executed. Defaults to false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getValidateOnly() {
    return validateOnly;
  }

  /**
   * If true, the request is validated but not actually executed. Defaults to false.
   * @param validateOnly validateOnly or {@code null} for none
   */
  public LaunchFlexTemplateRequest setValidateOnly(java.lang.Boolean validateOnly) {
    this.validateOnly = validateOnly;
    return this;
  }

  @Override
  public LaunchFlexTemplateRequest set(String fieldName, Object value) {
    return (LaunchFlexTemplateRequest) super.set(fieldName, value);
  }

  @Override
  public LaunchFlexTemplateRequest clone() {
    return (LaunchFlexTemplateRequest) super.clone();
  }

}
