/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information about the GPU usage on the worker.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GPUUsage extends com.google.api.client.json.GenericJson {

  /**
   * Required. Timestamp of the measurement.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String timestamp;

  /**
   * Required. Utilization info about the GPU.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GPUUtilization utilization;

  /**
   * Required. Timestamp of the measurement.
   * @return value or {@code null} for none
   */
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * Required. Timestamp of the measurement.
   * @param timestamp timestamp or {@code null} for none
   */
  public GPUUsage setTimestamp(String timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  /**
   * Required. Utilization info about the GPU.
   * @return value or {@code null} for none
   */
  public GPUUtilization getUtilization() {
    return utilization;
  }

  /**
   * Required. Utilization info about the GPU.
   * @param utilization utilization or {@code null} for none
   */
  public GPUUsage setUtilization(GPUUtilization utilization) {
    this.utilization = utilization;
    return this;
  }

  @Override
  public GPUUsage set(String fieldName, Object value) {
    return (GPUUsage) super.set(fieldName, value);
  }

  @Override
  public GPUUsage clone() {
    return (GPUUsage) super.clone();
  }

}
