/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information about an individual work item execution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WorkItemDetails extends com.google.api.client.json.GenericJson {

  /**
   * Attempt ID of this work item
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attemptId;

  /**
   * End time of this work item attempt. If the work item is completed, this is the actual end time
   * of the work item. Otherwise, it is the predicted end time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Metrics for this work item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricUpdate> metrics;

  static {
    // hack to force ProGuard to consider MetricUpdate used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricUpdate.class);
  }

  /**
   * Progress of this work item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ProgressTimeseries progress;

  /**
   * Start time of this work item attempt.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * State of this work item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Information about straggler detections for this work item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StragglerInfo stragglerInfo;

  /**
   * Name of this work item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String taskId;

  /**
   * Attempt ID of this work item
   * @return value or {@code null} for none
   */
  public java.lang.String getAttemptId() {
    return attemptId;
  }

  /**
   * Attempt ID of this work item
   * @param attemptId attemptId or {@code null} for none
   */
  public WorkItemDetails setAttemptId(java.lang.String attemptId) {
    this.attemptId = attemptId;
    return this;
  }

  /**
   * End time of this work item attempt. If the work item is completed, this is the actual end time
   * of the work item. Otherwise, it is the predicted end time.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * End time of this work item attempt. If the work item is completed, this is the actual end time
   * of the work item. Otherwise, it is the predicted end time.
   * @param endTime endTime or {@code null} for none
   */
  public WorkItemDetails setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Metrics for this work item.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricUpdate> getMetrics() {
    return metrics;
  }

  /**
   * Metrics for this work item.
   * @param metrics metrics or {@code null} for none
   */
  public WorkItemDetails setMetrics(java.util.List<MetricUpdate> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Progress of this work item.
   * @return value or {@code null} for none
   */
  public ProgressTimeseries getProgress() {
    return progress;
  }

  /**
   * Progress of this work item.
   * @param progress progress or {@code null} for none
   */
  public WorkItemDetails setProgress(ProgressTimeseries progress) {
    this.progress = progress;
    return this;
  }

  /**
   * Start time of this work item attempt.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Start time of this work item attempt.
   * @param startTime startTime or {@code null} for none
   */
  public WorkItemDetails setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * State of this work item.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * State of this work item.
   * @param state state or {@code null} for none
   */
  public WorkItemDetails setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Information about straggler detections for this work item.
   * @return value or {@code null} for none
   */
  public StragglerInfo getStragglerInfo() {
    return stragglerInfo;
  }

  /**
   * Information about straggler detections for this work item.
   * @param stragglerInfo stragglerInfo or {@code null} for none
   */
  public WorkItemDetails setStragglerInfo(StragglerInfo stragglerInfo) {
    this.stragglerInfo = stragglerInfo;
    return this;
  }

  /**
   * Name of this work item.
   * @return value or {@code null} for none
   */
  public java.lang.String getTaskId() {
    return taskId;
  }

  /**
   * Name of this work item.
   * @param taskId taskId or {@code null} for none
   */
  public WorkItemDetails setTaskId(java.lang.String taskId) {
    this.taskId = taskId;
    return this;
  }

  @Override
  public WorkItemDetails set(String fieldName, Object value) {
    return (WorkItemDetails) super.set(fieldName, value);
  }

  @Override
  public WorkItemDetails clone() {
    return (WorkItemDetails) super.clone();
  }

}
