/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information useful for streaming straggler identification and debugging.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingStragglerInfo extends com.google.api.client.json.GenericJson {

  /**
   * The event-time watermark lag at the time of the straggler detection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String dataWatermarkLag;

  /**
   * End time of this straggler.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Start time of this straggler.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The system watermark lag at the time of the straggler detection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String systemWatermarkLag;

  /**
   * Name of the worker where the straggler was detected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String workerName;

  /**
   * The event-time watermark lag at the time of the straggler detection.
   * @return value or {@code null} for none
   */
  public String getDataWatermarkLag() {
    return dataWatermarkLag;
  }

  /**
   * The event-time watermark lag at the time of the straggler detection.
   * @param dataWatermarkLag dataWatermarkLag or {@code null} for none
   */
  public StreamingStragglerInfo setDataWatermarkLag(String dataWatermarkLag) {
    this.dataWatermarkLag = dataWatermarkLag;
    return this;
  }

  /**
   * End time of this straggler.
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * End time of this straggler.
   * @param endTime endTime or {@code null} for none
   */
  public StreamingStragglerInfo setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Start time of this straggler.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Start time of this straggler.
   * @param startTime startTime or {@code null} for none
   */
  public StreamingStragglerInfo setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  /**
   * The system watermark lag at the time of the straggler detection.
   * @return value or {@code null} for none
   */
  public String getSystemWatermarkLag() {
    return systemWatermarkLag;
  }

  /**
   * The system watermark lag at the time of the straggler detection.
   * @param systemWatermarkLag systemWatermarkLag or {@code null} for none
   */
  public StreamingStragglerInfo setSystemWatermarkLag(String systemWatermarkLag) {
    this.systemWatermarkLag = systemWatermarkLag;
    return this;
  }

  /**
   * Name of the worker where the straggler was detected.
   * @return value or {@code null} for none
   */
  public java.lang.String getWorkerName() {
    return workerName;
  }

  /**
   * Name of the worker where the straggler was detected.
   * @param workerName workerName or {@code null} for none
   */
  public StreamingStragglerInfo setWorkerName(java.lang.String workerName) {
    this.workerName = workerName;
    return this;
  }

  @Override
  public StreamingStragglerInfo set(String fieldName, Object value) {
    return (StreamingStragglerInfo) super.set(fieldName, value);
  }

  @Override
  public StreamingStragglerInfo clone() {
    return (StreamingStragglerInfo) super.clone();
  }

}
