/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Operational limits imposed on streaming jobs by the backend.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingOperationalLimits extends com.google.api.client.json.GenericJson {

  /**
   * The maximum size for an element in bag state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxBagElementBytes;

  /**
   * The maximum size for an element in global data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxGlobalDataBytes;

  /**
   * The maximum size allowed for a key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxKeyBytes;

  /**
   * The maximum size for a single output element.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxProductionOutputBytes;

  /**
   * The maximum size for an element in sorted list state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxSortedListElementBytes;

  /**
   * The maximum size for a source state update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxSourceStateBytes;

  /**
   * The maximum size for a state tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxTagBytes;

  /**
   * The maximum size for a value state field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxValueBytes;

  /**
   * The maximum size for an element in bag state.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxBagElementBytes() {
    return maxBagElementBytes;
  }

  /**
   * The maximum size for an element in bag state.
   * @param maxBagElementBytes maxBagElementBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxBagElementBytes(java.lang.Long maxBagElementBytes) {
    this.maxBagElementBytes = maxBagElementBytes;
    return this;
  }

  /**
   * The maximum size for an element in global data.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxGlobalDataBytes() {
    return maxGlobalDataBytes;
  }

  /**
   * The maximum size for an element in global data.
   * @param maxGlobalDataBytes maxGlobalDataBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxGlobalDataBytes(java.lang.Long maxGlobalDataBytes) {
    this.maxGlobalDataBytes = maxGlobalDataBytes;
    return this;
  }

  /**
   * The maximum size allowed for a key.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxKeyBytes() {
    return maxKeyBytes;
  }

  /**
   * The maximum size allowed for a key.
   * @param maxKeyBytes maxKeyBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxKeyBytes(java.lang.Long maxKeyBytes) {
    this.maxKeyBytes = maxKeyBytes;
    return this;
  }

  /**
   * The maximum size for a single output element.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxProductionOutputBytes() {
    return maxProductionOutputBytes;
  }

  /**
   * The maximum size for a single output element.
   * @param maxProductionOutputBytes maxProductionOutputBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxProductionOutputBytes(java.lang.Long maxProductionOutputBytes) {
    this.maxProductionOutputBytes = maxProductionOutputBytes;
    return this;
  }

  /**
   * The maximum size for an element in sorted list state.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxSortedListElementBytes() {
    return maxSortedListElementBytes;
  }

  /**
   * The maximum size for an element in sorted list state.
   * @param maxSortedListElementBytes maxSortedListElementBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxSortedListElementBytes(java.lang.Long maxSortedListElementBytes) {
    this.maxSortedListElementBytes = maxSortedListElementBytes;
    return this;
  }

  /**
   * The maximum size for a source state update.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxSourceStateBytes() {
    return maxSourceStateBytes;
  }

  /**
   * The maximum size for a source state update.
   * @param maxSourceStateBytes maxSourceStateBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxSourceStateBytes(java.lang.Long maxSourceStateBytes) {
    this.maxSourceStateBytes = maxSourceStateBytes;
    return this;
  }

  /**
   * The maximum size for a state tag.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxTagBytes() {
    return maxTagBytes;
  }

  /**
   * The maximum size for a state tag.
   * @param maxTagBytes maxTagBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxTagBytes(java.lang.Long maxTagBytes) {
    this.maxTagBytes = maxTagBytes;
    return this;
  }

  /**
   * The maximum size for a value state field.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxValueBytes() {
    return maxValueBytes;
  }

  /**
   * The maximum size for a value state field.
   * @param maxValueBytes maxValueBytes or {@code null} for none
   */
  public StreamingOperationalLimits setMaxValueBytes(java.lang.Long maxValueBytes) {
    this.maxValueBytes = maxValueBytes;
    return this;
  }

  @Override
  public StreamingOperationalLimits set(String fieldName, Object value) {
    return (StreamingOperationalLimits) super.set(fieldName, value);
  }

  @Override
  public StreamingOperationalLimits clone() {
    return (StreamingOperationalLimits) super.clone();
  }

}
