/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information useful for straggler identification and debugging.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StragglerInfo extends com.google.api.client.json.GenericJson {

  /**
   * The straggler causes, keyed by the string representation of the StragglerCause enum and
   * contains specialized debugging information for each straggler cause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, StragglerDebuggingInfo> causes;

  static {
    // hack to force ProGuard to consider StragglerDebuggingInfo used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StragglerDebuggingInfo.class);
  }

  /**
   * The time when the work item attempt became a straggler.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * The straggler causes, keyed by the string representation of the StragglerCause enum and
   * contains specialized debugging information for each straggler cause.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, StragglerDebuggingInfo> getCauses() {
    return causes;
  }

  /**
   * The straggler causes, keyed by the string representation of the StragglerCause enum and
   * contains specialized debugging information for each straggler cause.
   * @param causes causes or {@code null} for none
   */
  public StragglerInfo setCauses(java.util.Map<String, StragglerDebuggingInfo> causes) {
    this.causes = causes;
    return this;
  }

  /**
   * The time when the work item attempt became a straggler.
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * The time when the work item attempt became a straggler.
   * @param startTime startTime or {@code null} for none
   */
  public StragglerInfo setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public StragglerInfo set(String fieldName, Object value) {
    return (StragglerInfo) super.set(fieldName, value);
  }

  @Override
  public StragglerInfo clone() {
    return (StragglerInfo) super.clone();
  }

}
