/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * The response to a SourceSplitRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceSplitResponse extends com.google.api.client.json.GenericJson {

  /**
   * If outcome is SPLITTING_HAPPENED, then this is a list of bundles into which the source was
   * split. Otherwise this field is ignored. This list can be empty, which means the source
   * represents an empty input.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DerivedSource> bundles;

  static {
    // hack to force ProGuard to consider DerivedSource used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DerivedSource.class);
  }

  /**
   * Indicates whether splitting happened and produced a list of bundles. If this is
   * USE_CURRENT_SOURCE_AS_IS, the current source should be processed "as is" without splitting.
   * "bundles" is ignored in this case. If this is SPLITTING_HAPPENED, then "bundles" contains a
   * list of bundles into which the source was split.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outcome;

  /**
   * DEPRECATED in favor of bundles.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SourceSplitShard> shards;

  /**
   * If outcome is SPLITTING_HAPPENED, then this is a list of bundles into which the source was
   * split. Otherwise this field is ignored. This list can be empty, which means the source
   * represents an empty input.
   * @return value or {@code null} for none
   */
  public java.util.List<DerivedSource> getBundles() {
    return bundles;
  }

  /**
   * If outcome is SPLITTING_HAPPENED, then this is a list of bundles into which the source was
   * split. Otherwise this field is ignored. This list can be empty, which means the source
   * represents an empty input.
   * @param bundles bundles or {@code null} for none
   */
  public SourceSplitResponse setBundles(java.util.List<DerivedSource> bundles) {
    this.bundles = bundles;
    return this;
  }

  /**
   * Indicates whether splitting happened and produced a list of bundles. If this is
   * USE_CURRENT_SOURCE_AS_IS, the current source should be processed "as is" without splitting.
   * "bundles" is ignored in this case. If this is SPLITTING_HAPPENED, then "bundles" contains a
   * list of bundles into which the source was split.
   * @return value or {@code null} for none
   */
  public java.lang.String getOutcome() {
    return outcome;
  }

  /**
   * Indicates whether splitting happened and produced a list of bundles. If this is
   * USE_CURRENT_SOURCE_AS_IS, the current source should be processed "as is" without splitting.
   * "bundles" is ignored in this case. If this is SPLITTING_HAPPENED, then "bundles" contains a
   * list of bundles into which the source was split.
   * @param outcome outcome or {@code null} for none
   */
  public SourceSplitResponse setOutcome(java.lang.String outcome) {
    this.outcome = outcome;
    return this;
  }

  /**
   * DEPRECATED in favor of bundles.
   * @return value or {@code null} for none
   */
  public java.util.List<SourceSplitShard> getShards() {
    return shards;
  }

  /**
   * DEPRECATED in favor of bundles.
   * @param shards shards or {@code null} for none
   */
  public SourceSplitResponse setShards(java.util.List<SourceSplitShard> shards) {
    this.shards = shards;
    return this;
  }

  @Override
  public SourceSplitResponse set(String fieldName, Object value) {
    return (SourceSplitResponse) super.set(fieldName, value);
  }

  @Override
  public SourceSplitResponse clone() {
    return (SourceSplitResponse) super.clone();
  }

}
