/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Per worker metrics.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PerWorkerMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Metrics for a particular unfused step and namespace.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PerStepNamespaceMetrics> perStepNamespaceMetrics;

  static {
    // hack to force ProGuard to consider PerStepNamespaceMetrics used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(PerStepNamespaceMetrics.class);
  }

  /**
   * Optional. Metrics for a particular unfused step and namespace.
   * @return value or {@code null} for none
   */
  public java.util.List<PerStepNamespaceMetrics> getPerStepNamespaceMetrics() {
    return perStepNamespaceMetrics;
  }

  /**
   * Optional. Metrics for a particular unfused step and namespace.
   * @param perStepNamespaceMetrics perStepNamespaceMetrics or {@code null} for none
   */
  public PerWorkerMetrics setPerStepNamespaceMetrics(java.util.List<PerStepNamespaceMetrics> perStepNamespaceMetrics) {
    this.perStepNamespaceMetrics = perStepNamespaceMetrics;
    return this;
  }

  @Override
  public PerWorkerMetrics set(String fieldName, Object value) {
    return (PerWorkerMetrics) super.set(fieldName, value);
  }

  @Override
  public PerWorkerMetrics clone() {
    return (PerWorkerMetrics) super.clone();
  }

}
