/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Streaming appliance snapshot configuration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StreamingApplianceSnapshotConfig extends com.google.api.client.json.GenericJson {

  /**
   * Indicates which endpoint is used to import appliance state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String importStateEndpoint;

  /**
   * If set, indicates the snapshot id for the snapshot being performed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snapshotId;

  /**
   * Indicates which endpoint is used to import appliance state.
   * @return value or {@code null} for none
   */
  public java.lang.String getImportStateEndpoint() {
    return importStateEndpoint;
  }

  /**
   * Indicates which endpoint is used to import appliance state.
   * @param importStateEndpoint importStateEndpoint or {@code null} for none
   */
  public StreamingApplianceSnapshotConfig setImportStateEndpoint(java.lang.String importStateEndpoint) {
    this.importStateEndpoint = importStateEndpoint;
    return this;
  }

  /**
   * If set, indicates the snapshot id for the snapshot being performed.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnapshotId() {
    return snapshotId;
  }

  /**
   * If set, indicates the snapshot id for the snapshot being performed.
   * @param snapshotId snapshotId or {@code null} for none
   */
  public StreamingApplianceSnapshotConfig setSnapshotId(java.lang.String snapshotId) {
    this.snapshotId = snapshotId;
    return this;
  }

  @Override
  public StreamingApplianceSnapshotConfig set(String fieldName, Object value) {
    return (StreamingApplianceSnapshotConfig) super.set(fieldName, value);
  }

  @Override
  public StreamingApplianceSnapshotConfig clone() {
    return (StreamingApplianceSnapshotConfig) super.clone();
  }

}
