/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information about the execution of a job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class JobExecutionDetails extends com.google.api.client.json.GenericJson {

  /**
   * If present, this response does not contain all requested tasks. To obtain the next page of
   * results, repeat the request with page_token set to this value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The stages of the job execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StageSummary> stages;

  /**
   * If present, this response does not contain all requested tasks. To obtain the next page of
   * results, repeat the request with page_token set to this value.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If present, this response does not contain all requested tasks. To obtain the next page of
   * results, repeat the request with page_token set to this value.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public JobExecutionDetails setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The stages of the job execution.
   * @return value or {@code null} for none
   */
  public java.util.List<StageSummary> getStages() {
    return stages;
  }

  /**
   * The stages of the job execution.
   * @param stages stages or {@code null} for none
   */
  public JobExecutionDetails setStages(java.util.List<StageSummary> stages) {
    this.stages = stages;
    return this;
  }

  @Override
  public JobExecutionDetails set(String fieldName, Object value) {
    return (JobExecutionDetails) super.set(fieldName, value);
  }

  @Override
  public JobExecutionDetails clone() {
    return (JobExecutionDetails) super.clone();
  }

}
