/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Container Spec.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContainerSpec extends com.google.api.client.json.GenericJson {

  /**
   * Default runtime environment for the job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FlexTemplateRuntimeEnvironment defaultEnvironment;

  /**
   * Name of the docker container image. E.g., gcr.io/project/some-image
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String image;

  /**
   * Cloud Storage path to self-signed certificate of private registry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageRepositoryCertPath;

  /**
   * Secret Manager secret id for password to authenticate to private registry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageRepositoryPasswordSecretId;

  /**
   * Secret Manager secret id for username to authenticate to private registry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String imageRepositoryUsernameSecretId;

  /**
   * Metadata describing a template including description and validation rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TemplateMetadata metadata;

  /**
   * Required. SDK info of the Flex Template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SDKInfo sdkInfo;

  /**
   * Default runtime environment for the job.
   * @return value or {@code null} for none
   */
  public FlexTemplateRuntimeEnvironment getDefaultEnvironment() {
    return defaultEnvironment;
  }

  /**
   * Default runtime environment for the job.
   * @param defaultEnvironment defaultEnvironment or {@code null} for none
   */
  public ContainerSpec setDefaultEnvironment(FlexTemplateRuntimeEnvironment defaultEnvironment) {
    this.defaultEnvironment = defaultEnvironment;
    return this;
  }

  /**
   * Name of the docker container image. E.g., gcr.io/project/some-image
   * @return value or {@code null} for none
   */
  public java.lang.String getImage() {
    return image;
  }

  /**
   * Name of the docker container image. E.g., gcr.io/project/some-image
   * @param image image or {@code null} for none
   */
  public ContainerSpec setImage(java.lang.String image) {
    this.image = image;
    return this;
  }

  /**
   * Cloud Storage path to self-signed certificate of private registry.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageRepositoryCertPath() {
    return imageRepositoryCertPath;
  }

  /**
   * Cloud Storage path to self-signed certificate of private registry.
   * @param imageRepositoryCertPath imageRepositoryCertPath or {@code null} for none
   */
  public ContainerSpec setImageRepositoryCertPath(java.lang.String imageRepositoryCertPath) {
    this.imageRepositoryCertPath = imageRepositoryCertPath;
    return this;
  }

  /**
   * Secret Manager secret id for password to authenticate to private registry.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageRepositoryPasswordSecretId() {
    return imageRepositoryPasswordSecretId;
  }

  /**
   * Secret Manager secret id for password to authenticate to private registry.
   * @param imageRepositoryPasswordSecretId imageRepositoryPasswordSecretId or {@code null} for none
   */
  public ContainerSpec setImageRepositoryPasswordSecretId(java.lang.String imageRepositoryPasswordSecretId) {
    this.imageRepositoryPasswordSecretId = imageRepositoryPasswordSecretId;
    return this;
  }

  /**
   * Secret Manager secret id for username to authenticate to private registry.
   * @return value or {@code null} for none
   */
  public java.lang.String getImageRepositoryUsernameSecretId() {
    return imageRepositoryUsernameSecretId;
  }

  /**
   * Secret Manager secret id for username to authenticate to private registry.
   * @param imageRepositoryUsernameSecretId imageRepositoryUsernameSecretId or {@code null} for none
   */
  public ContainerSpec setImageRepositoryUsernameSecretId(java.lang.String imageRepositoryUsernameSecretId) {
    this.imageRepositoryUsernameSecretId = imageRepositoryUsernameSecretId;
    return this;
  }

  /**
   * Metadata describing a template including description and validation rules.
   * @return value or {@code null} for none
   */
  public TemplateMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata describing a template including description and validation rules.
   * @param metadata metadata or {@code null} for none
   */
  public ContainerSpec setMetadata(TemplateMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Required. SDK info of the Flex Template.
   * @return value or {@code null} for none
   */
  public SDKInfo getSdkInfo() {
    return sdkInfo;
  }

  /**
   * Required. SDK info of the Flex Template.
   * @param sdkInfo sdkInfo or {@code null} for none
   */
  public ContainerSpec setSdkInfo(SDKInfo sdkInfo) {
    this.sdkInfo = sdkInfo;
    return this;
  }

  @Override
  public ContainerSpec set(String fieldName, Object value) {
    return (ContainerSpec) super.set(fieldName, value);
  }

  @Override
  public ContainerSpec clone() {
    return (ContainerSpec) super.clone();
  }

}
